/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.action;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.NotificationConfig;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateNotificationConfigRequest
extends ActionRequest
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(UpdateNotificationConfigRequest.class);
    private final String configId;
    private final NotificationConfig notificationConfig;
    public static final Writeable.Reader<UpdateNotificationConfigRequest> READER = UpdateNotificationConfigRequest::new;

    public static UpdateNotificationConfigRequest parse(XContentParser parser) throws IOException {
        return UpdateNotificationConfigRequest.parse(parser, null);
    }

    public static UpdateNotificationConfigRequest parse(XContentParser parser, String id) throws IOException {
        String configId = id;
        NotificationConfig notificationConfig = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "config_id": {
                    configId = parser.text();
                    continue block8;
                }
                case "config": {
                    notificationConfig = NotificationConfig.parse(parser);
                    continue block8;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing UpdateNotificationConfigRequest", (Object)fieldName);
        }
        if (configId == null) {
            throw new IllegalArgumentException("config_id field absent");
        }
        if (notificationConfig == null) {
            throw new IllegalArgumentException("config field absent");
        }
        return new UpdateNotificationConfigRequest(configId, notificationConfig);
    }

    public UpdateNotificationConfigRequest(String configId, NotificationConfig notificationConfig) {
        this.configId = configId;
        this.notificationConfig = notificationConfig;
    }

    public UpdateNotificationConfigRequest(StreamInput in) throws IOException {
        super(in);
        this.configId = in.readString();
        this.notificationConfig = NotificationConfig.READER.read(in);
    }

    public String getConfigId() {
        return this.configId;
    }

    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.configId);
        this.notificationConfig.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("config_id", this.configId);
        builder.field("config", this.notificationConfig);
        return builder.endObject();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty(this.configId)) {
            validationException = ValidateActions.addValidationError((String)"configId is null or empty", validationException);
        }
        return validationException;
    }
}

