/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Attachment
implements BaseModel {
    private static final Logger log = LogManager.getLogger(Attachment.class);
    private final String fileName;
    private final String fileEncoding;
    private final String fileData;
    private final String fileContentType;
    public static final Writeable.Reader<Attachment> READER = Attachment::new;

    public Attachment(String fileName, String fileEncoding, String fileData, String fileContentType) {
        if (fileName == null) {
            throw new IllegalArgumentException("attachment:fileName not present");
        }
        if (fileEncoding == null) {
            throw new IllegalArgumentException("attachment:fileEncoding not present");
        }
        if (fileData == null) {
            throw new IllegalArgumentException("attachment:fileData not present");
        }
        this.fileName = fileName;
        this.fileEncoding = fileEncoding;
        this.fileData = fileData;
        this.fileContentType = fileContentType;
    }

    public Attachment(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readString(), in.readOptionalString());
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public String getFileData() {
        return this.fileData;
    }

    public String getFileContentType() {
        return this.fileContentType;
    }

    public static Attachment parse(XContentParser parser) throws IOException {
        String fileName = null;
        String fileEncoding = null;
        String fileData = null;
        String fileContentType = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String dataType = parser.currentName();
            parser.nextToken();
            switch (dataType) {
                case "file_name": {
                    fileName = parser.text();
                    continue block12;
                }
                case "file_encoding": {
                    fileEncoding = parser.text();
                    continue block12;
                }
                case "file_data": {
                    fileData = parser.text();
                    continue block12;
                }
                case "file_content_type": {
                    fileContentType = parser.textOrNull();
                    continue block12;
                }
            }
            parser.skipChildren();
            log.info("Skipping Unknown field {}", (Object)dataType);
        }
        if (fileName == null) {
            throw new IllegalArgumentException("attachment:fileName not present");
        }
        if (fileEncoding == null) {
            throw new IllegalArgumentException("attachment:fileEncoding not present");
        }
        if (fileData == null) {
            throw new IllegalArgumentException("attachment:fileData not present");
        }
        return new Attachment(fileName, fileEncoding, fileData, fileContentType);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("file_name", this.fileName);
        builder.field("file_encoding", this.fileEncoding);
        builder.field("file_data", this.fileData);
        Attachment.fieldIfNotNull(builder, "file_content_type", this.fileContentType);
        builder.endObject();
        return builder;
    }

    private static void fieldIfNotNull(XContentBuilder builder, String fieldName, Object value) throws IOException {
        if (value != null) {
            builder.field(fieldName, value);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fileName);
        out.writeString(this.fileEncoding);
        out.writeString(this.fileData);
        out.writeOptionalString(this.fileContentType);
    }

    public String toString() {
        return "Attachment{fileName='" + this.fileName + "', fileEncoding='" + this.fileEncoding + "', fileData='" + this.fileData + "', fileContentType='" + this.fileContentType + "'}";
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileEncoding, this.fileData, this.fileContentType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.fileName, other.fileName) && Objects.equals(this.fileEncoding, other.fileEncoding) && Objects.equals(this.fileData, other.fileData) && Objects.equals(this.fileContentType, other.fileContentType);
    }

    public static class Builder {
        private String fileName;
        private String fileEncoding;
        private String fileData;
        private String fileContentType;

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return this;
        }

        public Builder fileData(String fileData) {
            this.fileData = fileData;
            return this;
        }

        public Builder fileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        public Attachment build() {
            if (this.fileName == null) {
                throw new IllegalArgumentException("attachment:fileName not present");
            }
            if (this.fileEncoding == null) {
                throw new IllegalArgumentException("attachment:fileEncoding not present");
            }
            if (this.fileData == null) {
                throw new IllegalArgumentException("attachment:fileData not present");
            }
            return new Attachment(this.fileName, this.fileEncoding, this.fileData, this.fileContentType);
        }
    }
}

