/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.notifications.model.ConfigType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Channel
implements BaseModel {
    private static final Logger log = LogManager.getLogger(Channel.class);
    public static final Writeable.Reader<Channel> READER = Channel::new;
    private final String configId;
    private final String name;
    private final String description;
    private final ConfigType configType;
    private final boolean isEnabled;

    public Channel(String configId, String name, String description, ConfigType configType) {
        this(configId, name, description, configType, true);
    }

    public Channel(String configId, String name, String description, ConfigType configType, boolean isEnabled) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("name is null or empty");
        }
        if (Strings.isNullOrEmpty(configId)) {
            throw new IllegalArgumentException("config id is null or empty");
        }
        this.configId = configId;
        this.name = name;
        this.description = description != null ? description : "";
        this.configType = configType;
        this.isEnabled = isEnabled;
    }

    public Channel(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readString(), in.readEnum(ConfigType.class), in.readBoolean());
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigType getConfigType() {
        return this.configType;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static Channel parse(XContentParser parser) throws IOException {
        String configId = null;
        String name = null;
        String description = "";
        ConfigType configType = null;
        boolean isEnabled = true;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "config_id": {
                    configId = parser.text();
                    continue block14;
                }
                case "name": {
                    name = parser.text();
                    continue block14;
                }
                case "description": {
                    description = parser.text();
                    continue block14;
                }
                case "config_type": {
                    configType = ConfigType.fromTagOrDefault(parser.text());
                    continue block14;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block14;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing Channel", (Object)fieldName);
        }
        if (configId == null) {
            throw new IllegalArgumentException("config_id field absent");
        }
        if (name == null) {
            throw new IllegalArgumentException("name field absent");
        }
        if (configType == null) {
            throw new IllegalArgumentException("config_type field absent");
        }
        return new Channel(configId, name, description, configType, isEnabled);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.configId);
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeEnum(this.configType);
        out.writeBoolean(this.isEnabled);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("config_id", this.configId);
        builder.field("name", this.name);
        builder.field("description", this.description);
        builder.field("config_type", this.configType.getTag());
        builder.field("is_enabled", this.isEnabled);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "Channel{configId='" + this.configId + "', name='" + this.name + "', description='" + this.description + "', configType=" + String.valueOf((Object)this.configType) + ", isEnabled=" + this.isEnabled + "}";
    }

    public int hashCode() {
        int result = this.configId != null ? this.configId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.configType != null ? this.configType.hashCode() : 0);
        result = 31 * result + (this.isEnabled ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        if (this.isEnabled != other.isEnabled) {
            return false;
        }
        if (this.configId != null ? !this.configId.equals(other.configId) : other.configId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(other.description) : other.description != null) {
            return false;
        }
        return this.configType == other.configType;
    }
}

