/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.Attachment;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChannelMessage
implements BaseModel {
    private static final Logger log = LogManager.getLogger(ChannelMessage.class);
    private final String textDescription;
    private final String htmlDescription;
    private final Attachment attachment;
    public static final Writeable.Reader<ChannelMessage> READER = ChannelMessage::new;

    public ChannelMessage(String textDescription, String htmlDescription, Attachment attachment) {
        if (Strings.isNullOrEmpty(textDescription)) {
            throw new IllegalArgumentException("text message part is null or empty");
        }
        this.textDescription = textDescription;
        this.htmlDescription = htmlDescription;
        this.attachment = attachment;
    }

    public ChannelMessage(StreamInput in) throws IOException {
        this(in.readString(), in.readOptionalString(), in.readOptionalWriteable(Attachment.READER));
    }

    public String getTextDescription() {
        return this.textDescription;
    }

    public String getHtmlDescription() {
        return this.htmlDescription;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public static ChannelMessage parse(XContentParser parser) throws IOException {
        String textDescription = null;
        String htmlDescription = null;
        Attachment attachment = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "text_description": {
                    textDescription = parser.text();
                    continue block10;
                }
                case "html_description": {
                    htmlDescription = parser.textOrNull();
                    continue block10;
                }
                case "attachment": {
                    attachment = Attachment.parse(parser);
                    continue block10;
                }
            }
            parser.skipChildren();
            log.info("Skipping Unknown field {}", (Object)fieldName);
        }
        if (textDescription == null) {
            throw new IllegalArgumentException("text_description not present");
        }
        return new ChannelMessage(textDescription, htmlDescription, attachment);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.textDescription);
        out.writeOptionalString(this.htmlDescription);
        out.writeOptionalWriteable(this.attachment);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("text_description", this.textDescription);
        ChannelMessage.fieldIfNotNull(builder, "html_description", this.htmlDescription);
        ChannelMessage.fieldIfNotNull(builder, "attachment", this.attachment);
        builder.endObject();
        return builder;
    }

    private static void fieldIfNotNull(XContentBuilder builder, String field, Object value) throws IOException {
        if (value != null) {
            builder.field(field, value);
        }
    }

    public String toString() {
        return "ChannelMessage{textDescription='" + this.textDescription + "', htmlDescription='" + this.htmlDescription + "', attachment=" + String.valueOf(this.attachment) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.textDescription, this.htmlDescription, this.attachment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChannelMessage)) {
            return false;
        }
        ChannelMessage other = (ChannelMessage)obj;
        return Objects.equals(this.textDescription, other.textDescription) && Objects.equals(this.htmlDescription, other.htmlDescription) && Objects.equals(this.attachment, other.attachment);
    }

    public static class Builder {
        private String textDescription;
        private String htmlDescription;
        private Attachment attachment;

        public Builder textDescription(String textDescription) {
            this.textDescription = textDescription;
            return this;
        }

        public Builder htmlDescription(String htmlDescription) {
            this.htmlDescription = htmlDescription;
            return this;
        }

        public Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public ChannelMessage build() {
            if (Strings.isNullOrEmpty(this.textDescription)) {
                throw new IllegalArgumentException("text message part is null or empty");
            }
            return new ChannelMessage(this.textDescription, this.htmlDescription, this.attachment);
        }
    }
}

