/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chime
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(Chime.class);
    public static final Writeable.Reader<Chime> READER = Chime::new;
    public static final XParser<Chime> X_PARSER = Chime::parse;
    private final String url;

    public Chime(String url) throws MalformedURLException {
        if (Strings.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        ValidationUtils.validateUrl((String)url);
        this.url = url;
    }

    public Chime(StreamInput in) throws IOException, MalformedURLException {
        this(in.readString());
    }

    public String getUrl() {
        return this.url;
    }

    public static Chime parse(XContentParser parser) throws IOException {
        String url = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if ("url".equals(fieldName)) {
                url = parser.text();
                continue;
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing Chime destination", (Object)fieldName);
        }
        if (url == null) {
            throw new IllegalArgumentException("url field absent");
        }
        return new Chime(url);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.url);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("url", this.url);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "Chime{url='" + this.url + "'}";
    }

    public int hashCode() {
        return this.url != null ? this.url.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Chime)) {
            return false;
        }
        Chime other = (Chime)obj;
        return this.url != null ? this.url.equals(other.url) : other.url == null;
    }
}

