/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.EnumParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ConfigType {
    NONE("none"),
    SLACK("slack"),
    CHIME("chime"),
    WEBHOOK("webhook"),
    EMAIL("email"),
    SNS("sns"),
    SES_ACCOUNT("ses_account"),
    SMTP_ACCOUNT("smtp_account"),
    EMAIL_GROUP("email_group"),
    MICROSOFT_TEAMS("microsoft_teams");

    private final String tag;
    private static final Map<String, ConfigType> TAG_MAP;
    public static final EnumParser<ConfigType> ENUM_PARSER;

    private ConfigType(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return this.tag;
    }

    public static ConfigType fromTagOrDefault(String tag) {
        if (tag == null) {
            return NONE;
        }
        ConfigType result = TAG_MAP.get(tag);
        return result != null ? result : NONE;
    }

    static {
        HashMap<String, ConfigType> map = new HashMap<String, ConfigType>();
        for (ConfigType type : ConfigType.values()) {
            map.put(type.tag, type);
        }
        TAG_MAP = Collections.unmodifiableMap(map);
        ENUM_PARSER = ConfigType::fromTagOrDefault;
    }
}

