/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeliveryStatus
implements BaseModel {
    private static final Logger log = LogManager.getLogger(DeliveryStatus.class);
    public static final Writeable.Reader<DeliveryStatus> READER = DeliveryStatus::new;
    private final String statusCode;
    private final String statusText;

    public DeliveryStatus(String statusCode, String statusText) {
        if (Strings.isNullOrEmpty(statusCode)) {
            throw new IllegalArgumentException("StatusCode is null or empty");
        }
        if (Strings.isNullOrEmpty(statusText)) {
            throw new IllegalArgumentException("statusText is null or empty");
        }
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public DeliveryStatus(StreamInput in) throws IOException {
        this(in.readString(), in.readString());
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public static DeliveryStatus parse(XContentParser parser) throws IOException {
        String statusCode = null;
        String statusText = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "status_code": {
                    statusCode = parser.text();
                    continue block8;
                }
                case "status_text": {
                    statusText = parser.text();
                    continue block8;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing deliveryStatus", (Object)fieldName);
        }
        if (statusCode == null) {
            throw new IllegalArgumentException("status_code field absent");
        }
        if (statusText == null) {
            throw new IllegalArgumentException("status_text field absent");
        }
        return new DeliveryStatus(statusCode, statusText);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.statusCode);
        out.writeString(this.statusText);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("status_code", this.statusCode);
        builder.field("status_text", this.statusText);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "DeliveryStatus{statusCode='" + this.statusCode + "', statusText='" + this.statusText + "'}";
    }

    public int hashCode() {
        int result = this.statusCode != null ? this.statusCode.hashCode() : 0;
        result = 31 * result + (this.statusText != null ? this.statusText.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeliveryStatus)) {
            return false;
        }
        DeliveryStatus other = (DeliveryStatus)obj;
        if (this.statusCode != null ? !this.statusCode.equals(other.statusCode) : other.statusCode != null) {
            return false;
        }
        return this.statusText != null ? this.statusText.equals(other.statusText) : other.statusText == null;
    }
}

