/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.EmailRecipient;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Email
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(Email.class);
    public static final Writeable.Reader<Email> READER = Email::new;
    public static final XParser<Email> X_PARSER = Email::parse;
    private final String emailAccountID;
    private final List<EmailRecipient> recipients;
    private final List<String> emailGroupIds;

    public Email(String emailAccountID, List<EmailRecipient> recipients, List<String> emailGroupIds) {
        if (Strings.isNullOrEmpty(emailAccountID)) {
            throw new IllegalArgumentException("emailAccountID is null or empty");
        }
        this.emailAccountID = emailAccountID;
        this.recipients = recipients == null ? Collections.emptyList() : Collections.unmodifiableList(recipients);
        this.emailGroupIds = emailGroupIds == null ? Collections.emptyList() : Collections.unmodifiableList(emailGroupIds);
    }

    public Email(StreamInput in) throws IOException {
        this(in.readString(), in.readList(EmailRecipient.READER), in.readStringList());
    }

    public String getEmailAccountID() {
        return this.emailAccountID;
    }

    public List<EmailRecipient> getRecipients() {
        return this.recipients;
    }

    public List<String> getEmailGroupIds() {
        return this.emailGroupIds;
    }

    public static Email parse(XContentParser parser) throws IOException {
        String emailAccountID = null;
        List<EmailRecipient> recipients = Collections.emptyList();
        List<String> emailGroupIds = Collections.emptyList();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "email_account_id": {
                    emailAccountID = parser.text();
                    continue block10;
                }
                case "recipient_list": {
                    recipients = Email.parseRecipients(parser);
                    continue block10;
                }
                case "email_group_id_list": {
                    emailGroupIds = XContentUtils.stringList(parser);
                    continue block10;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing Email", (Object)fieldName);
        }
        if (emailAccountID == null) {
            throw new IllegalArgumentException("email_account_id field absent");
        }
        return new Email(emailAccountID, recipients, emailGroupIds);
    }

    private static List<EmailRecipient> parseRecipients(XContentParser parser) throws IOException {
        ArrayList<EmailRecipient> list = new ArrayList<EmailRecipient>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list.add(EmailRecipient.parse(parser));
        }
        return list;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.emailAccountID);
        out.writeList(this.recipients);
        out.writeStringCollection(this.emailGroupIds);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("email_account_id", this.emailAccountID);
        builder.field("recipient_list", this.recipients);
        builder.field("email_group_id_list", this.emailGroupIds);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "Email{emailAccountID='" + this.emailAccountID + "', recipients=" + String.valueOf(this.recipients) + ", emailGroupIds=" + String.valueOf(this.emailGroupIds) + "}";
    }

    public int hashCode() {
        int result = this.emailAccountID != null ? this.emailAccountID.hashCode() : 0;
        result = 31 * result + (this.recipients != null ? this.recipients.hashCode() : 0);
        result = 31 * result + (this.emailGroupIds != null ? this.emailGroupIds.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Email)) {
            return false;
        }
        Email other = (Email)obj;
        if (this.emailAccountID != null ? !this.emailAccountID.equals(other.emailAccountID) : other.emailAccountID != null) {
            return false;
        }
        if (this.recipients != null ? !this.recipients.equals(other.recipients) : other.recipients != null) {
            return false;
        }
        return this.emailGroupIds != null ? this.emailGroupIds.equals(other.emailGroupIds) : other.emailGroupIds == null;
    }
}

