/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.EmailRecipient;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmailGroup
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(EmailGroup.class);
    public static final Writeable.Reader<EmailGroup> READER = EmailGroup::new;
    public static final XParser<EmailGroup> X_PARSER = EmailGroup::parse;
    private final List<EmailRecipient> recipients;

    public EmailGroup(List<EmailRecipient> recipients) {
        this.recipients = recipients == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<EmailRecipient>(recipients));
    }

    public EmailGroup(StreamInput in) throws IOException {
        this(in.readList(EmailRecipient.READER));
    }

    public List<EmailRecipient> getRecipients() {
        return this.recipients;
    }

    public static EmailGroup parse(XContentParser parser) throws IOException {
        List<EmailRecipient> recipients = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "recipient_list": {
                    recipients = EmailGroup.parseRecipients(parser);
                    continue block6;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing EmailGroup", (Object)fieldName);
        }
        if (recipients == null) {
            throw new IllegalArgumentException("recipient_list field absent");
        }
        return new EmailGroup(recipients);
    }

    private static List<EmailRecipient> parseRecipients(XContentParser parser) throws IOException {
        ArrayList<EmailRecipient> list = new ArrayList<EmailRecipient>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list.add(EmailRecipient.parse(parser));
        }
        return list;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.recipients);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("recipient_list", this.recipients);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "EmailGroup{recipients=" + String.valueOf(this.recipients) + "}";
    }

    public int hashCode() {
        return this.recipients != null ? this.recipients.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmailGroup)) {
            return false;
        }
        EmailGroup other = (EmailGroup)obj;
        return this.recipients != null ? this.recipients.equals(other.recipients) : other.recipients == null;
    }
}

