/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmailRecipient
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(EmailRecipient.class);
    public static final Writeable.Reader<EmailRecipient> READER = EmailRecipient::new;
    public static final XParser<EmailRecipient> XPARSER = EmailRecipient::parse;
    private final String recipient;

    public EmailRecipient(String recipient) {
        ValidationUtils.validateEmail((String)recipient);
        this.recipient = recipient;
    }

    public EmailRecipient(StreamInput in) throws IOException {
        this(in.readString());
    }

    public String getRecipient() {
        return this.recipient;
    }

    public static EmailRecipient parse(XContentParser parser) throws IOException {
        String recipient = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "recipient": {
                    recipient = parser.text();
                    continue block6;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing EmailRecipient", (Object)fieldName);
        }
        if (recipient == null) {
            throw new IllegalArgumentException("recipient field absent");
        }
        return new EmailRecipient(recipient);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.recipient);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("recipient", this.recipient);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "EmailRecipient{recipient='" + this.recipient + "'}";
    }

    public int hashCode() {
        return this.recipient != null ? this.recipient.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmailRecipient)) {
            return false;
        }
        EmailRecipient other = (EmailRecipient)obj;
        return this.recipient != null ? this.recipient.equals(other.recipient) : other.recipient == null;
    }
}

