/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.notifications.model.DeliveryStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmailRecipientStatus
implements BaseModel {
    private static final Logger log = LogManager.getLogger(EmailRecipientStatus.class);
    public static final Writeable.Reader<EmailRecipientStatus> READER = EmailRecipientStatus::new;
    private final String recipient;
    private final DeliveryStatus deliveryStatus;

    public EmailRecipientStatus(String recipient, DeliveryStatus deliveryStatus) {
        ValidationUtils.validateEmail((String)recipient);
        this.recipient = recipient;
        this.deliveryStatus = deliveryStatus;
    }

    public EmailRecipientStatus(StreamInput in) throws IOException {
        this(in.readString(), DeliveryStatus.READER.read(in));
    }

    public String getRecipient() {
        return this.recipient;
    }

    public DeliveryStatus getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public static EmailRecipientStatus parse(XContentParser parser) throws IOException {
        String recipient = null;
        DeliveryStatus deliveryStatus = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "recipient": {
                    recipient = parser.text();
                    continue block8;
                }
                case "delivery_status": {
                    deliveryStatus = DeliveryStatus.parse(parser);
                    continue block8;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing Email Recipient Status", (Object)fieldName);
        }
        if (recipient == null) {
            throw new IllegalArgumentException("recipient field absent");
        }
        if (deliveryStatus == null) {
            throw new IllegalArgumentException("delivery_status field absent");
        }
        return new EmailRecipientStatus(recipient, deliveryStatus);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.recipient);
        this.deliveryStatus.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("recipient", this.recipient);
        builder.field("delivery_status", this.deliveryStatus);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "EmailRecipientStatus{recipient='" + this.recipient + "', deliveryStatus=" + String.valueOf(this.deliveryStatus) + "}";
    }

    public int hashCode() {
        int result = this.recipient != null ? this.recipient.hashCode() : 0;
        result = 31 * result + (this.deliveryStatus != null ? this.deliveryStatus.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmailRecipientStatus)) {
            return false;
        }
        EmailRecipientStatus other = (EmailRecipientStatus)obj;
        if (this.recipient != null ? !this.recipient.equals(other.recipient) : other.recipient != null) {
            return false;
        }
        return this.deliveryStatus != null ? this.deliveryStatus.equals(other.deliveryStatus) : other.deliveryStatus == null;
    }
}

