/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.notifications.model.SeverityType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventSource
implements BaseModel {
    private static final Logger log = LogManager.getLogger(EventSource.class);
    private final String title;
    private final String referenceId;
    private final SeverityType severity;
    private final List<String> tags;
    public static final Writeable.Reader<EventSource> READER = EventSource::new;

    public EventSource(String title, String referenceId, SeverityType severity) {
        this(title, referenceId, severity, Collections.emptyList());
    }

    public EventSource(String title, String referenceId, SeverityType severity, List<String> tags) {
        if (Strings.isNullOrEmpty(title)) {
            throw new IllegalArgumentException("name is null or empty");
        }
        this.title = title;
        this.referenceId = referenceId;
        this.severity = severity != null ? severity : SeverityType.INFO;
        this.tags = tags != null ? Collections.unmodifiableList(new ArrayList<String>(tags)) : Collections.emptyList();
    }

    public EventSource(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readEnum(SeverityType.class), in.readStringList());
    }

    public String getTitle() {
        return this.title;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public SeverityType getSeverity() {
        return this.severity;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public static EventSource parse(XContentParser parser) throws IOException {
        String title = null;
        String referenceId = null;
        SeverityType severity = SeverityType.INFO;
        List<String> tags = Collections.emptyList();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "title": {
                    title = parser.text();
                    continue block12;
                }
                case "reference_id": {
                    referenceId = parser.text();
                    continue block12;
                }
                case "severity": {
                    severity = SeverityType.fromTagOrDefault(parser.text());
                    continue block12;
                }
                case "tags": {
                    tags = EventSource.parseStringList(parser);
                    continue block12;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing EventSource", (Object)fieldName);
        }
        if (title == null) {
            throw new IllegalArgumentException("title field absent");
        }
        if (referenceId == null) {
            throw new IllegalArgumentException("reference_id field absent");
        }
        return new EventSource(title, referenceId, severity, tags);
    }

    private static List<String> parseStringList(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        ArrayList<String> list = new ArrayList<String>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list.add(parser.text());
        }
        return list;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("title", this.title);
        builder.field("reference_id", this.referenceId);
        builder.field("severity", this.severity.getTag());
        builder.field("tags", this.tags);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.title);
        out.writeString(this.referenceId);
        out.writeEnum(this.severity);
        out.writeStringCollection(this.tags);
    }

    public String toString() {
        return "EventSource{title='" + this.title + "', referenceId='" + this.referenceId + "', severity=" + String.valueOf((Object)this.severity) + ", tags=" + String.valueOf(this.tags) + "}";
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.referenceId != null ? this.referenceId.hashCode() : 0);
        result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventSource)) {
            return false;
        }
        EventSource other = (EventSource)obj;
        if (this.title != null ? !this.title.equals(other.title) : other.title != null) {
            return false;
        }
        if (this.referenceId != null ? !this.referenceId.equals(other.referenceId) : other.referenceId != null) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        return this.tags != null ? this.tags.equals(other.tags) : other.tags == null;
    }
}

