/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.notifications.model.ConfigType;
import io.skylite.core.notifications.model.DeliveryStatus;
import io.skylite.core.notifications.model.EmailRecipientStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventStatus
implements BaseModel {
    private static final Logger log = LogManager.getLogger(EventStatus.class);
    public static final Writeable.Reader<EventStatus> READER = EventStatus::new;
    private final String configId;
    private final String configName;
    private final ConfigType configType;
    private final List<EmailRecipientStatus> emailRecipientStatus;
    private final DeliveryStatus deliveryStatus;

    public EventStatus(String configId, String configName, ConfigType configType) {
        this(configId, configName, configType, Collections.emptyList(), null);
    }

    public EventStatus(String configId, String configName, ConfigType configType, DeliveryStatus deliveryStatus) {
        this(configId, configName, configType, Collections.emptyList(), deliveryStatus);
    }

    public EventStatus(String configId, String configName, ConfigType configType, List<EmailRecipientStatus> emailRecipientStatus, DeliveryStatus deliveryStatus) {
        if (Strings.isNullOrEmpty(configId)) {
            throw new IllegalArgumentException("config id is null or empty");
        }
        if (Strings.isNullOrEmpty(configName)) {
            throw new IllegalArgumentException("config name is null or empty");
        }
        switch (configType) {
            case CHIME: 
            case WEBHOOK: 
            case SLACK: 
            case SNS: 
            case MICROSOFT_TEAMS: {
                if (deliveryStatus != null) break;
                throw new IllegalArgumentException("deliveryStatus must not be null for configType: " + String.valueOf((Object)configType));
            }
            case EMAIL: {
                if (emailRecipientStatus != null && !emailRecipientStatus.isEmpty()) break;
                throw new IllegalArgumentException("emailRecipientStatus must not be empty for EMAIL configType");
            }
            case NONE: {
                log.info("Some config field not recognized");
                break;
            }
            default: {
                log.info("non-allowed config type for Status");
            }
        }
        this.configId = configId;
        this.configName = configName;
        this.configType = configType;
        this.emailRecipientStatus = emailRecipientStatus == null ? Collections.emptyList() : Collections.unmodifiableList(emailRecipientStatus);
        this.deliveryStatus = deliveryStatus;
    }

    public EventStatus(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readEnum(ConfigType.class), in.readList(EmailRecipientStatus.READER), in.readOptionalWriteable(DeliveryStatus.READER));
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getConfigName() {
        return this.configName;
    }

    public ConfigType getConfigType() {
        return this.configType;
    }

    public List<EmailRecipientStatus> getEmailRecipientStatus() {
        return this.emailRecipientStatus;
    }

    public DeliveryStatus getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public static EventStatus parse(XContentParser parser) throws IOException {
        String configName = null;
        String configId = null;
        ConfigType configType = null;
        List<EmailRecipientStatus> emailRecipientStatus = Collections.emptyList();
        DeliveryStatus deliveryStatus = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "config_name": {
                    configName = parser.text();
                    continue block14;
                }
                case "config_id": {
                    configId = parser.text();
                    continue block14;
                }
                case "config_type": {
                    configType = ConfigType.fromTagOrDefault(parser.text());
                    continue block14;
                }
                case "email_recipient_status": {
                    emailRecipientStatus = XContentUtils.objectList(parser, EmailRecipientStatus::parse);
                    continue block14;
                }
                case "delivery_status": {
                    deliveryStatus = DeliveryStatus.parse(parser);
                    continue block14;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing EventStatus", (Object)fieldName);
        }
        if (configName == null) {
            throw new IllegalArgumentException("config_name field absent");
        }
        if (configId == null) {
            throw new IllegalArgumentException("config_id field absent");
        }
        if (configType == null) {
            throw new IllegalArgumentException("config_type field absent");
        }
        return new EventStatus(configId, configName, configType, emailRecipientStatus, deliveryStatus);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.configId);
        out.writeString(this.configName);
        out.writeEnum(this.configType);
        out.writeList(this.emailRecipientStatus);
        out.writeOptionalWriteable(this.deliveryStatus);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("config_id", this.configId);
        builder.field("config_type", this.configType.getTag());
        builder.field("config_name", this.configName);
        builder.field("email_recipient_status", this.emailRecipientStatus);
        XContentUtils.fieldIfNotNull(builder, "delivery_status", this.deliveryStatus);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "EventStatus{configId='" + this.configId + "', configName='" + this.configName + "', configType=" + String.valueOf((Object)this.configType) + ", emailRecipientStatus=" + String.valueOf(this.emailRecipientStatus) + ", deliveryStatus=" + String.valueOf(this.deliveryStatus) + "}";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configId, this.configName, this.configType, this.emailRecipientStatus, this.deliveryStatus});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventStatus)) {
            return false;
        }
        EventStatus other = (EventStatus)obj;
        return Objects.equals(this.configId, other.configId) && Objects.equals(this.configName, other.configName) && this.configType == other.configType && Objects.equals(this.emailRecipientStatus, other.emailRecipientStatus) && Objects.equals(this.deliveryStatus, other.deliveryStatus);
    }
}

