/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import java.util.HashMap;
import java.util.Map;

public enum HttpMethodType {
    POST("POST"),
    PUT("PUT"),
    PATCH("PATCH");

    private final String tag;
    private static final Map<String, HttpMethodType> TAG_MAP;

    private HttpMethodType(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return this.tag;
    }

    public static HttpMethodType fromTagOrDefault(String tag) {
        if (tag == null) {
            return POST;
        }
        return TAG_MAP.getOrDefault(tag, POST);
    }

    static {
        TAG_MAP = new HashMap<String, HttpMethodType>();
        for (HttpMethodType t : HttpMethodType.values()) {
            TAG_MAP.put(t.tag, t);
        }
    }
}

