/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;

public class MessageContent {
    private final String title;
    private final String textDescription;
    private final String htmlDescription;
    private final String fileName;
    private final String fileEncoding;
    private final String fileData;
    private final String fileContentType;

    public MessageContent(String title, String textDescription) {
        this(title, textDescription, null, null, null, null, null);
    }

    public MessageContent(String title, String textDescription, String htmlDescription, String fileName, String fileEncoding, String fileData, String fileContentType) {
        if (Strings.isNullOrEmpty(title)) {
            throw new IllegalArgumentException("title is null or empty");
        }
        if (Strings.isNullOrEmpty(textDescription)) {
            throw new IllegalArgumentException("text message part is null or empty");
        }
        this.title = title;
        this.textDescription = textDescription;
        this.htmlDescription = htmlDescription;
        this.fileName = fileName;
        this.fileEncoding = fileEncoding;
        this.fileData = fileData;
        this.fileContentType = fileContentType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTextDescription() {
        return this.textDescription;
    }

    public String getHtmlDescription() {
        return this.htmlDescription;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public String getFileData() {
        return this.fileData;
    }

    public String getFileContentType() {
        return this.fileContentType;
    }

    public String buildMessageWithTitle() {
        return this.title + "\n\n" + this.textDescription;
    }
}

