/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import java.util.HashMap;
import java.util.Map;

public enum MethodType {
    NONE("none"),
    SSL("ssl"),
    START_TLS("start_tls");

    private final String tag;
    private static final Map<String, MethodType> TAG_MAP;

    private MethodType(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return this.tag;
    }

    public static MethodType fromTagOrDefault(String tag) {
        if (tag == null) {
            return NONE;
        }
        return TAG_MAP.getOrDefault(tag, NONE);
    }

    static {
        TAG_MAP = new HashMap<String, MethodType>();
        for (MethodType m : MethodType.values()) {
            TAG_MAP.put(m.tag, m);
        }
    }
}

