/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MicrosoftTeams
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(MicrosoftTeams.class);
    private final String url;
    public static final Writeable.Reader<MicrosoftTeams> READER = MicrosoftTeams::new;
    public static final XParser<MicrosoftTeams> X_PARSER = MicrosoftTeams::parse;

    public MicrosoftTeams(String url) throws MalformedURLException {
        if (Strings.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        ValidationUtils.validateUrl((String)url);
        this.url = url;
    }

    public MicrosoftTeams(StreamInput in) throws IOException, MalformedURLException {
        this(in.readString());
    }

    public String getUrl() {
        return this.url;
    }

    public static MicrosoftTeams parse(XContentParser parser) throws IOException {
        String url = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if ("url".equals(fieldName)) {
                url = parser.text();
                continue;
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing MicrosoftTeams destination", (Object)fieldName);
        }
        if (url == null) {
            throw new IllegalArgumentException("url field absent");
        }
        return new MicrosoftTeams(url);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.url);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (builder == null) {
            throw new IllegalArgumentException("XContentBuilder cannot be null");
        }
        return builder.startObject().field("url", this.url).endObject();
    }

    public String toString() {
        return "MicrosoftTeams{url='" + this.url + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MicrosoftTeams)) {
            return false;
        }
        MicrosoftTeams that = (MicrosoftTeams)o;
        return this.url.equals(that.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

