/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.notifications.model.ConfigType;
import io.skylite.core.notifications.model.config.ConfigDataProperties;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotificationConfig
implements BaseModel {
    private static final Logger log = LogManager.getLogger(NotificationConfig.class);
    public static final Writeable.Reader<NotificationConfig> READER = NotificationConfig::new;
    private final String name;
    private final String description;
    private final ConfigType configType;
    private final BaseConfigData configData;
    private final boolean isEnabled;

    public NotificationConfig(String name, String description, ConfigType configType, BaseConfigData configData) {
        this(name, description, configType, configData, true);
    }

    public NotificationConfig(String name, String description, ConfigType configType, BaseConfigData configData, boolean isEnabled) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("name is null or empty");
        }
        if (!ConfigDataProperties.validateConfigData(configType, configData)) {
            throw new IllegalArgumentException("ConfigType: " + String.valueOf((Object)configType) + " and data doesn't match");
        }
        if (configType == ConfigType.NONE) {
            log.info("Some config field not recognized");
        }
        this.name = name;
        this.description = description != null ? description : "";
        this.configType = configType;
        this.configData = configData;
        this.isEnabled = isEnabled;
    }

    public NotificationConfig(StreamInput in) throws IOException {
        String name = in.readString();
        String description = in.readString();
        ConfigType configType = in.readEnum(ConfigType.class);
        boolean isEnabled = in.readBoolean();
        ConfigType typeForData = in.readEnum(ConfigType.class);
        Writeable.Reader<? extends BaseConfigData> reader = ConfigDataProperties.getReaderForConfigType(typeForData);
        BaseConfigData configData = in.readOptionalWriteable(reader);
        this.name = name;
        this.description = description != null ? description : "";
        this.configType = configType;
        this.configData = configData;
        this.isEnabled = isEnabled;
        if (!ConfigDataProperties.validateConfigData(configType, configData)) {
            throw new IllegalArgumentException("ConfigType: " + String.valueOf((Object)configType) + " and data doesn't match");
        }
        if (configType == ConfigType.NONE) {
            log.info("Some config field not recognized");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigType getConfigType() {
        return this.configType;
    }

    public BaseConfigData getConfigData() {
        return this.configData;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("description", this.description);
        builder.field("config_type", this.configType.getTag());
        builder.field("is_enabled", this.isEnabled);
        XContentUtils.fieldIfNotNull(builder, this.configType.getTag(), this.configData);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeEnum(this.configType);
        out.writeBoolean(this.isEnabled);
        out.writeEnum(this.configType);
        out.writeOptionalWriteable(this.configData);
    }

    public static NotificationConfig parse(XContentParser parser) throws IOException {
        String name = null;
        String description = "";
        ConfigType configType = null;
        boolean isEnabled = true;
        BaseConfigData configData = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block12;
                }
                case "description": {
                    description = parser.text();
                    continue block12;
                }
                case "config_type": {
                    configType = ConfigType.fromTagOrDefault(parser.text());
                    continue block12;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block12;
                }
            }
            ConfigType configTypeForTag = ConfigType.fromTagOrDefault(fieldName);
            if (configTypeForTag != ConfigType.NONE && configData == null) {
                configData = ConfigDataProperties.createConfigData(configTypeForTag, parser);
                continue;
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing configuration", (Object)fieldName);
        }
        if (name == null) {
            throw new IllegalArgumentException("name field absent");
        }
        if (configType == null) {
            throw new IllegalArgumentException("config_type field absent");
        }
        return new NotificationConfig(name, description, configType, configData, isEnabled);
    }

    public String toString() {
        return "NotificationConfig{name='" + this.name + "', description='" + this.description + "', configType=" + String.valueOf((Object)this.configType) + ", configData=" + String.valueOf(this.configData) + ", isEnabled=" + this.isEnabled + "}";
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.configType != null ? this.configType.hashCode() : 0);
        result = 31 * result + (this.configData != null ? this.configData.hashCode() : 0);
        result = 31 * result + (this.isEnabled ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig other = (NotificationConfig)obj;
        if (this.isEnabled != other.isEnabled) {
            return false;
        }
        if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(other.description) : other.description != null) {
            return false;
        }
        if (this.configType != other.configType) {
            return false;
        }
        return this.configData != null ? this.configData.equals(other.configData) : other.configData == null;
    }
}

