/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.notifications.model.NotificationConfig;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotificationConfigInfo
implements BaseModel {
    private static final Logger log = LogManager.getLogger(NotificationConfigInfo.class);
    private final String configId;
    private final Instant lastUpdatedTime;
    private final Instant createdTime;
    private final NotificationConfig notificationConfig;
    public static final Writeable.Reader<NotificationConfigInfo> READER = NotificationConfigInfo::new;

    public NotificationConfigInfo(String configId, Instant lastUpdatedTime, Instant createdTime, NotificationConfig notificationConfig) {
        if (Strings.isNullOrEmpty(configId)) {
            throw new IllegalArgumentException("config id is null or empty");
        }
        if (lastUpdatedTime == null) {
            throw new IllegalArgumentException("lastUpdatedTime is null");
        }
        if (createdTime == null) {
            throw new IllegalArgumentException("createdTime is null");
        }
        if (notificationConfig == null) {
            throw new IllegalArgumentException("notificationConfig is null");
        }
        this.configId = configId;
        this.lastUpdatedTime = lastUpdatedTime;
        this.createdTime = createdTime;
        this.notificationConfig = notificationConfig;
    }

    public NotificationConfigInfo(StreamInput in) throws IOException {
        this.configId = in.readString();
        this.lastUpdatedTime = in.readInstant();
        this.createdTime = in.readInstant();
        this.notificationConfig = NotificationConfig.READER.read(in);
    }

    public String getConfigId() {
        return this.configId;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    public static NotificationConfigInfo parse(XContentParser parser) throws IOException {
        String configId = null;
        Instant lastUpdatedTime = null;
        Instant createdTime = null;
        NotificationConfig notificationConfig = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "config_id": {
                    configId = parser.text();
                    continue block12;
                }
                case "last_updated_time_ms": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block12;
                }
                case "created_time_ms": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block12;
                }
                case "config": {
                    notificationConfig = NotificationConfig.parse(parser);
                    continue block12;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing configuration", (Object)fieldName);
        }
        if (configId == null) {
            throw new IllegalArgumentException("config_id field absent");
        }
        if (lastUpdatedTime == null) {
            throw new IllegalArgumentException("last_updated_time_ms field absent");
        }
        if (createdTime == null) {
            throw new IllegalArgumentException("created_time_ms field absent");
        }
        if (notificationConfig == null) {
            throw new IllegalArgumentException("config field absent");
        }
        return new NotificationConfigInfo(configId, lastUpdatedTime, createdTime, notificationConfig);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.configId);
        out.writeInstant(this.lastUpdatedTime);
        out.writeInstant(this.createdTime);
        this.notificationConfig.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (builder == null) {
            throw new IllegalArgumentException("XContentBuilder cannot be null");
        }
        return builder.startObject().field("config_id", this.configId).field("last_updated_time_ms", this.lastUpdatedTime.toEpochMilli()).field("created_time_ms", this.createdTime.toEpochMilli()).field("config", this.notificationConfig).endObject();
    }

    public String toString() {
        return "NotificationConfigInfo{configId='" + this.configId + "', lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", createdTime=" + String.valueOf(this.createdTime) + ", notificationConfig=" + String.valueOf(this.notificationConfig) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationConfigInfo)) {
            return false;
        }
        NotificationConfigInfo that = (NotificationConfigInfo)o;
        if (!this.configId.equals(that.configId)) {
            return false;
        }
        if (!this.lastUpdatedTime.equals(that.lastUpdatedTime)) {
            return false;
        }
        if (!this.createdTime.equals(that.createdTime)) {
            return false;
        }
        return this.notificationConfig.equals(that.notificationConfig);
    }

    public int hashCode() {
        int result = this.configId.hashCode();
        result = 31 * result + this.lastUpdatedTime.hashCode();
        result = 31 * result + this.createdTime.hashCode();
        result = 31 * result + this.notificationConfig.hashCode();
        return result;
    }
}

