/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.notifications.model.EventStatus;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotificationEvent
implements BaseModel {
    private static final Logger log = LogManager.getLogger(NotificationEvent.class);
    private final EventSource eventSource;
    private final List<EventStatus> statusList;
    public static final Writeable.Reader<NotificationEvent> READER = NotificationEvent::new;

    public static NotificationEvent parse(XContentParser parser) throws IOException {
        EventSource eventSource = null;
        List<EventStatus> statusList = List.of();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if ("event_source".equals(fieldName)) {
                eventSource = EventSource.parse(parser);
                continue;
            }
            if ("status_list".equals(fieldName)) {
                statusList = XContentUtils.objectList(parser, EventStatus::parse);
                continue;
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing notification event", (Object)fieldName);
        }
        if (eventSource == null) {
            throw new IllegalArgumentException("event_source field absent");
        }
        if (statusList == null || statusList.isEmpty()) {
            throw new IllegalArgumentException("status_list field absent or empty");
        }
        return new NotificationEvent(eventSource, statusList);
    }

    public NotificationEvent(EventSource eventSource, List<EventStatus> statusList) {
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource is null");
        if (statusList == null || statusList.isEmpty()) {
            throw new IllegalArgumentException("statusList is null or empty");
        }
        this.statusList = List.copyOf(statusList);
    }

    public NotificationEvent(StreamInput input) throws IOException {
        this(EventSource.READER.read(input), input.readList(EventStatus.READER));
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }

    public List<EventStatus> getStatusList() {
        return this.statusList;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.eventSource.writeTo(out);
        out.writeList(this.statusList);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("event_source", this.eventSource).field("status_list", this.statusList).endObject();
        return builder;
    }

    public String toString() {
        try {
            return XContentHelper.toXContent(this, MediaTypeRegistry.JSON, ToXContent.EMPTY_PARAMS, true).utf8ToString();
        }
        catch (IOException e) {
            log.debug("Failed to convert NotificationEvent to string", (Throwable)e);
            return super.toString() + " threw " + e.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationEvent that = (NotificationEvent)o;
        return Objects.equals(this.eventSource, that.eventSource) && Objects.equals(this.statusList, that.statusList);
    }

    public int hashCode() {
        return Objects.hash(this.eventSource, this.statusList);
    }
}

