/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseModel;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchHits;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;

public abstract class SearchResults<ItemClass extends BaseModel>
implements BaseModel {
    private static final Logger log = LogManager.getLogger(SearchResults.class);
    protected final long startIndex;
    protected final long totalHits;
    protected final TotalHits.Relation totalHitRelation;
    protected final String objectListFieldName;
    protected final List<ItemClass> objectList;

    protected static String convertRelation(TotalHits.Relation totalHitRelation) {
        return totalHitRelation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte";
    }

    protected static TotalHits.Relation convertRelation(String totalHitRelation) {
        return "eq".equals(totalHitRelation) ? TotalHits.Relation.EQUAL_TO : TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
    }

    protected SearchResults(String objectListFieldName, ItemClass objectItem) {
        this.startIndex = 0L;
        this.totalHits = 1L;
        this.totalHitRelation = TotalHits.Relation.EQUAL_TO;
        this.objectListFieldName = objectListFieldName;
        ArrayList<ItemClass> list = new ArrayList<ItemClass>(1);
        list.add(objectItem);
        this.objectList = list;
    }

    protected SearchResults(long startIndex, long totalHits, TotalHits.Relation totalHitRelation, String objectListFieldName, List<ItemClass> objectList) {
        this.startIndex = startIndex;
        this.totalHits = totalHits;
        this.totalHitRelation = totalHitRelation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = objectList;
    }

    protected SearchResults(long from, SearchResponse response, SearchHitParser<ItemClass> searchHitParser, String objectListFieldName) throws IOException {
        TotalHits.Relation relation;
        long totalHitsVal;
        ArrayList<ItemClass> mutableList = new ArrayList<ItemClass>();
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits.getHits()) {
            mutableList.add((BaseModel)searchHitParser.parse(hit));
        }
        TotalHits totalHitsObj = hits.getTotalHits();
        if (totalHitsObj == null) {
            totalHitsVal = mutableList.size();
            relation = TotalHits.Relation.EQUAL_TO;
        } else {
            totalHitsVal = totalHitsObj.value();
            relation = totalHitsObj.relation();
        }
        this.startIndex = from;
        this.totalHits = totalHitsVal;
        this.totalHitRelation = relation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = mutableList;
    }

    protected SearchResults(XContentParser parser, String objectListFieldName) throws IOException {
        long startIndex = 0L;
        long totalHits = 0L;
        TotalHits.Relation relation = TotalHits.Relation.EQUAL_TO;
        List<ItemClass> objectList = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "start_index": {
                    startIndex = parser.longValue();
                    continue block10;
                }
                case "total_hits": {
                    totalHits = parser.longValue();
                    continue block10;
                }
                case "total_hit_relation": {
                    relation = SearchResults.convertRelation(parser.text());
                    continue block10;
                }
            }
            if (objectListFieldName.equals(fieldName)) {
                objectList = this.parseItemList(parser);
                continue;
            }
            parser.skipChildren();
            log.info("Skipping Unknown field {}", (Object)fieldName);
        }
        if (objectList == null) {
            throw new IllegalArgumentException(objectListFieldName + " field absent");
        }
        if (totalHits == 0L) {
            totalHits = objectList.size();
        }
        this.startIndex = startIndex;
        this.totalHits = totalHits;
        this.totalHitRelation = relation;
        this.objectListFieldName = objectListFieldName;
        this.objectList = objectList;
    }

    protected SearchResults(StreamInput in, Writeable.Reader<ItemClass> reader) throws IOException {
        this(in.readLong(), in.readLong(), in.readEnum(TotalHits.Relation.class), in.readString(), in.readList(reader));
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public TotalHits.Relation getTotalHitRelation() {
        return this.totalHitRelation;
    }

    public String getObjectListFieldName() {
        return this.objectListFieldName;
    }

    public List<ItemClass> getObjectList() {
        return this.objectList;
    }

    private List<ItemClass> parseItemList(XContentParser parser) throws IOException {
        ArrayList<ItemClass> retList = new ArrayList<ItemClass>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            retList.add(this.parseItem(parser));
        }
        return retList;
    }

    protected abstract ItemClass parseItem(XContentParser var1) throws IOException;

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.startIndex);
        out.writeLong(this.totalHits);
        out.writeEnum(this.totalHitRelation);
        out.writeString(this.objectListFieldName);
        out.writeList(this.objectList);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("start_index", this.startIndex);
        builder.field("total_hits", this.totalHits);
        builder.field("total_hit_relation", SearchResults.convertRelation(this.totalHitRelation));
        builder.startArray(this.objectListFieldName);
        for (BaseModel item : this.objectList) {
            item.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @FunctionalInterface
    public static interface SearchHitParser<ItemClass> {
        public ItemClass parse(SearchHit var1) throws IOException;
    }
}

