/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SesAccount
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(SesAccount.class);
    private final String awsRegion;
    private final String roleArn;
    private final String fromAddress;
    public static final Writeable.Reader<SesAccount> READER = SesAccount::new;
    public static final XParser<SesAccount> X_PARSER = SesAccount::parse;

    public SesAccount(String awsRegion, String roleArn, String fromAddress) {
        if (Strings.isNullOrEmpty(awsRegion)) {
            throw new IllegalArgumentException("awsRegion is null or empty");
        }
        ValidationUtils.validateEmail((String)fromAddress);
        if (roleArn != null) {
            ValidationUtils.validateIamRoleArn((String)roleArn);
        }
        this.awsRegion = awsRegion;
        this.roleArn = roleArn;
        this.fromAddress = fromAddress;
    }

    public SesAccount(StreamInput input) throws IOException {
        this.awsRegion = input.readString();
        this.roleArn = input.readOptionalString();
        this.fromAddress = input.readString();
        if (Strings.isNullOrEmpty(this.awsRegion)) {
            throw new IllegalArgumentException("awsRegion is null or empty");
        }
        ValidationUtils.validateEmail((String)this.fromAddress);
        if (this.roleArn != null) {
            ValidationUtils.validateIamRoleArn((String)this.roleArn);
        }
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public static SesAccount parse(XContentParser parser) throws IOException {
        String awsRegion = null;
        String roleArn = null;
        String fromAddress = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "region": {
                    awsRegion = parser.text();
                    continue block10;
                }
                case "role_arn": {
                    if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                        roleArn = null;
                        continue block10;
                    }
                    roleArn = parser.text();
                    continue block10;
                }
                case "from_address": {
                    fromAddress = parser.text();
                    continue block10;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing SesAccount", (Object)fieldName);
        }
        if (awsRegion == null) {
            throw new IllegalArgumentException("region field absent");
        }
        if (fromAddress == null) {
            throw new IllegalArgumentException("from_address field absent");
        }
        return new SesAccount(awsRegion, roleArn, fromAddress);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.awsRegion);
        out.writeOptionalString(this.roleArn);
        out.writeString(this.fromAddress);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return XContentUtils.fieldIfNotNull(builder.startObject().field("region", this.awsRegion), "role_arn", this.roleArn).field("from_address", this.fromAddress).endObject();
    }

    public String toString() {
        return "SesAccount{awsRegion='" + this.awsRegion + "', roleArn='" + this.roleArn + "', fromAddress='" + this.fromAddress + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SesAccount)) {
            return false;
        }
        SesAccount that = (SesAccount)o;
        return Objects.equals(this.awsRegion, that.awsRegion) && Objects.equals(this.roleArn, that.roleArn) && Objects.equals(this.fromAddress, that.fromAddress);
    }

    public int hashCode() {
        return Objects.hash(this.awsRegion, this.roleArn, this.fromAddress);
    }
}

