/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.EnumParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum SeverityType {
    NONE("none"),
    HIGH("high"),
    INFO("info"),
    CRITICAL("critical");

    private final String tag;
    private static final Map<String, SeverityType> TAG_MAP;
    public static final EnumParser<SeverityType> ENUM_PARSER;

    private SeverityType(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return this.tag;
    }

    public static SeverityType fromTagOrDefault(String tag) {
        if (tag == null) {
            return NONE;
        }
        SeverityType result = TAG_MAP.get(tag);
        return result != null ? result : NONE;
    }

    static {
        HashMap<String, SeverityType> map = new HashMap<String, SeverityType>();
        for (SeverityType type : SeverityType.values()) {
            map.put(type.tag, type);
        }
        TAG_MAP = Collections.unmodifiableMap(map);
        ENUM_PARSER = SeverityType::fromTagOrDefault;
    }
}

