/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Slack
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(Slack.class);
    private final String url;
    public static final Writeable.Reader<Slack> READER = Slack::new;
    public static final XParser<Slack> X_PARSER = Slack::parse;

    public Slack(String url) throws MalformedURLException {
        if (Strings.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        ValidationUtils.validateUrl((String)url);
        this.url = url;
    }

    public Slack(StreamInput input) throws IOException, MalformedURLException {
        this.url = input.readString();
        if (Strings.isNullOrEmpty(this.url)) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        ValidationUtils.validateUrl((String)this.url);
    }

    public String getUrl() {
        return this.url;
    }

    public static Slack parse(XContentParser parser) throws IOException {
        String url = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if ("url".equals(fieldName)) {
                url = parser.text();
                continue;
            }
            parser.skipChildren();
            log.info("Unexpected field: {}, while parsing Slack destination", (Object)fieldName);
        }
        if (url == null) {
            throw new IllegalArgumentException("url field absent");
        }
        return new Slack(url);
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.url);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("url", this.url).endObject();
    }

    public String toString() {
        return "Slack{url='" + this.url + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Slack)) {
            return false;
        }
        Slack slack = (Slack)o;
        return Objects.equals(this.url, slack.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }
}

