/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.MethodType;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmtpAccount
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(SmtpAccount.class);
    private final String host;
    private final int port;
    private final MethodType method;
    private final String fromAddress;
    public static final Writeable.Reader<SmtpAccount> READER = SmtpAccount::new;
    public static final XParser<SmtpAccount> X_PARSER = SmtpAccount::parse;

    public SmtpAccount(String host, int port, MethodType method, String fromAddress) {
        if (Strings.isNullOrEmpty(host)) {
            throw new IllegalArgumentException("host is null or empty");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("port should be a positive value");
        }
        ValidationUtils.validateEmail((String)fromAddress);
        this.host = host;
        this.port = port;
        this.method = method;
        this.fromAddress = fromAddress;
    }

    public SmtpAccount(StreamInput input) throws IOException {
        this.host = input.readString();
        this.port = input.readInt();
        this.method = input.readEnum(MethodType.class);
        this.fromAddress = input.readString();
        if (Strings.isNullOrEmpty(this.host)) {
            throw new IllegalArgumentException("host is null or empty");
        }
        if (this.port <= 0) {
            throw new IllegalArgumentException("port should be a positive value");
        }
        ValidationUtils.validateEmail((String)this.fromAddress);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public static SmtpAccount parse(XContentParser parser) throws IOException {
        String host = null;
        Integer port = null;
        MethodType method = null;
        String fromAddress = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "host": {
                    host = parser.text();
                    continue block12;
                }
                case "port": {
                    port = parser.intValue();
                    continue block12;
                }
                case "method": {
                    method = MethodType.fromTagOrDefault(parser.text());
                    continue block12;
                }
                case "from_address": {
                    fromAddress = parser.text();
                    continue block12;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {} while parsing SmtpAccount", (Object)fieldName);
        }
        if (host == null) {
            throw new IllegalArgumentException("host field absent");
        }
        if (port == null) {
            throw new IllegalArgumentException("port field absent");
        }
        if (method == null) {
            throw new IllegalArgumentException("method field absent");
        }
        if (fromAddress == null) {
            throw new IllegalArgumentException("from_address field absent");
        }
        return new SmtpAccount(host, port, method, fromAddress);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.host);
        out.writeInt(this.port);
        out.writeEnum(this.method);
        out.writeString(this.fromAddress);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("host", this.host).field("port", this.port).field("method", this.method.getTag()).field("from_address", this.fromAddress).endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmtpAccount)) {
            return false;
        }
        SmtpAccount that = (SmtpAccount)o;
        return this.port == that.port && Objects.equals(this.host, that.host) && this.method == that.method && Objects.equals(this.fromAddress, that.fromAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.method, this.fromAddress});
    }
}

