/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.core.xcontent.util.XContentUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Sns
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(Sns.class);
    private static final Pattern SNS_ARN_REGEX = Pattern.compile("^arn:aws(-[^:]+)?:sns:([a-zA-Z0-9-]+):([0-9]{12}):([a-zA-Z_0-9+=,.@\\-_/]+)$");
    private final String topicArn;
    private final String roleArn;
    public static final Writeable.Reader<Sns> READER = Sns::new;
    public static final XParser<Sns> X_PARSER = Sns::parse;

    public Sns(String topicArn, String roleArn) {
        if (!SNS_ARN_REGEX.matcher(topicArn).find()) {
            throw new IllegalArgumentException("Invalid AWS SNS topic ARN: " + topicArn);
        }
        if (roleArn != null) {
            ValidationUtils.validateIamRoleArn((String)roleArn);
        }
        this.topicArn = topicArn;
        this.roleArn = roleArn;
    }

    public Sns(StreamInput input) throws IOException {
        this.topicArn = input.readString();
        this.roleArn = input.readOptionalString();
        if (!SNS_ARN_REGEX.matcher(this.topicArn).find()) {
            throw new IllegalArgumentException("Invalid AWS SNS topic ARN: " + this.topicArn);
        }
        if (this.roleArn != null) {
            ValidationUtils.validateIamRoleArn((String)this.roleArn);
        }
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public static Sns parse(XContentParser parser) throws IOException {
        String topicArn = null;
        String roleArn = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "topic_arn": {
                    topicArn = parser.textOrNull();
                    continue block8;
                }
                case "role_arn": {
                    roleArn = parser.textOrNull();
                    continue block8;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {} while parsing SNS destination", (Object)fieldName);
        }
        if (topicArn == null) {
            throw new IllegalArgumentException("topic_arn field absent");
        }
        return new Sns(topicArn, roleArn);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.topicArn);
        out.writeOptionalString(this.roleArn);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("topic_arn", this.topicArn);
        XContentUtils.fieldIfNotNull(builder, "role_arn", this.roleArn);
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sns)) {
            return false;
        }
        Sns sns = (Sns)o;
        return Objects.equals(this.topicArn, sns.topicArn) && Objects.equals(this.roleArn, sns.roleArn);
    }

    public int hashCode() {
        return Objects.hash(this.topicArn, this.roleArn);
    }
}

