/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model;

import io.skylite.common.util.ValidationUtils;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.HttpMethodType;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Webhook
implements BaseConfigData {
    private static final Logger log = LogManager.getLogger(Webhook.class);
    private final String url;
    private final Map<String, String> headerParams;
    private final HttpMethodType method;
    public static final Writeable.Reader<Webhook> READER = Webhook::new;
    public static final XParser<Webhook> X_PARSER = Webhook::parse;

    public Webhook(String url) throws MalformedURLException {
        this(url, Collections.emptyMap(), HttpMethodType.POST);
    }

    public Webhook(String url, Map<String, String> headerParams) throws MalformedURLException {
        this(url, headerParams, HttpMethodType.POST);
    }

    public Webhook(String url, Map<String, String> headerParams, HttpMethodType method) throws MalformedURLException {
        if (Strings.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        ValidationUtils.validateUrl((String)url);
        this.url = url;
        this.headerParams = headerParams == null ? Collections.emptyMap() : Map.copyOf(headerParams);
        this.method = method == null ? HttpMethodType.POST : method;
    }

    public Webhook(StreamInput input) throws IOException, MalformedURLException {
        this.url = input.readString();
        this.headerParams = input.readMap(StreamInput::readString, StreamInput::readString);
        this.method = input.readEnum(HttpMethodType.class);
        if (Strings.isNullOrEmpty(this.url)) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        ValidationUtils.validateUrl((String)this.url);
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaderParams() {
        return this.headerParams;
    }

    public HttpMethodType getMethod() {
        return this.method;
    }

    public static Webhook parse(XContentParser parser) throws IOException {
        String url = null;
        Map<String, String> headerParams = Collections.emptyMap();
        HttpMethodType method = HttpMethodType.POST;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "url": {
                    url = parser.text();
                    continue block10;
                }
                case "header_params": {
                    headerParams = Webhook.parseHeaderParams(parser);
                    continue block10;
                }
                case "method": {
                    method = HttpMethodType.fromTagOrDefault(parser.text());
                    continue block10;
                }
            }
            parser.skipChildren();
            log.info("Unexpected field: {} while parsing Webhook destination", (Object)fieldName);
        }
        if (url == null) {
            throw new IllegalArgumentException("url field absent");
        }
        return new Webhook(url, headerParams, method);
    }

    private static Map<String, String> parseHeaderParams(XContentParser parser) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String key = parser.currentName();
            parser.nextToken();
            if (parser.currentToken().isValue()) {
                map.put(key, parser.text());
                continue;
            }
            parser.skipChildren();
            log.info("Skipping non-scalar header param value for key {}", (Object)key);
        }
        return map;
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.url);
        output.writeMap(this.headerParams, StreamOutput::writeString, StreamOutput::writeString);
        output.writeEnum(this.method);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("url", this.url).field("header_params", (Object)this.headerParams).field("method", this.method.getTag()).endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Webhook)) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.url, webhook.url) && Objects.equals(this.headerParams, webhook.headerParams) && this.method == webhook.method;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.headerParams, this.method});
    }
}

