/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model.config;

import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.Chime;
import io.skylite.core.notifications.model.ConfigType;
import io.skylite.core.notifications.model.Email;
import io.skylite.core.notifications.model.EmailGroup;
import io.skylite.core.notifications.model.MicrosoftTeams;
import io.skylite.core.notifications.model.SesAccount;
import io.skylite.core.notifications.model.Slack;
import io.skylite.core.notifications.model.SmtpAccount;
import io.skylite.core.notifications.model.Sns;
import io.skylite.core.notifications.model.Webhook;
import io.skylite.core.notifications.model.XParser;
import io.skylite.core.xcontent.XContentParser;
import java.util.EnumMap;
import java.util.Map;

public final class ConfigDataProperties {
    private static final Map<ConfigType, ConfigProperty> CONFIG_PROPERTIES_MAP = new EnumMap<ConfigType, ConfigProperty>(ConfigType.class);

    private ConfigDataProperties() {
    }

    public static Writeable.Reader<? extends BaseConfigData> getReaderForConfigType(ConfigType configType) {
        ConfigProperty property = CONFIG_PROPERTIES_MAP.get((Object)configType);
        if (property == null) {
            throw new IllegalArgumentException("Transport action used with unknown ConfigType: " + String.valueOf((Object)configType));
        }
        return property.reader;
    }

    public static boolean validateConfigData(ConfigType type, BaseConfigData configData) {
        if (type == ConfigType.NONE) {
            return true;
        }
        if (configData == null) {
            return false;
        }
        switch (type) {
            case SLACK: {
                return configData instanceof Slack;
            }
            case WEBHOOK: {
                return configData instanceof Webhook;
            }
            case EMAIL: {
                return configData instanceof Email;
            }
            case EMAIL_GROUP: {
                return configData instanceof EmailGroup;
            }
            case SMTP_ACCOUNT: {
                return configData instanceof SmtpAccount;
            }
            case CHIME: {
                return configData instanceof Chime;
            }
            case SNS: {
                return configData instanceof Sns;
            }
            case SES_ACCOUNT: {
                return configData instanceof SesAccount;
            }
            case MICROSOFT_TEAMS: {
                return configData instanceof MicrosoftTeams;
            }
        }
        return false;
    }

    public static BaseConfigData createConfigData(ConfigType configType, XContentParser parser) {
        ConfigProperty property = CONFIG_PROPERTIES_MAP.get((Object)configType);
        if (property == null) {
            return null;
        }
        try {
            return property.parser.parse(parser);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse config data for type " + String.valueOf((Object)configType), e);
        }
    }

    static {
        CONFIG_PROPERTIES_MAP.put(ConfigType.SLACK, new ConfigProperty(Slack.READER, Slack.X_PARSER));
        CONFIG_PROPERTIES_MAP.put(ConfigType.CHIME, new ConfigProperty(Chime.READER, Chime.X_PARSER));
        CONFIG_PROPERTIES_MAP.put(ConfigType.WEBHOOK, new ConfigProperty(Webhook.READER, Webhook.X_PARSER));
        CONFIG_PROPERTIES_MAP.put(ConfigType.EMAIL, new ConfigProperty(Email.READER, Email.X_PARSER));
        CONFIG_PROPERTIES_MAP.put(ConfigType.SNS, new ConfigProperty(Sns.READER, Sns.X_PARSER));
        CONFIG_PROPERTIES_MAP.put(ConfigType.SES_ACCOUNT, new ConfigProperty(SesAccount.READER, SesAccount.X_PARSER));
        CONFIG_PROPERTIES_MAP.put(ConfigType.EMAIL_GROUP, new ConfigProperty(EmailGroup.READER, EmailGroup.X_PARSER));
        CONFIG_PROPERTIES_MAP.put(ConfigType.SMTP_ACCOUNT, new ConfigProperty(SmtpAccount.READER, SmtpAccount.X_PARSER));
        CONFIG_PROPERTIES_MAP.put(ConfigType.MICROSOFT_TEAMS, new ConfigProperty(MicrosoftTeams.READER, MicrosoftTeams.X_PARSER));
    }

    private static final class ConfigProperty {
        final Writeable.Reader<? extends BaseConfigData> reader;
        final XParser<? extends BaseConfigData> parser;

        ConfigProperty(Writeable.Reader<? extends BaseConfigData> reader, XParser<? extends BaseConfigData> parser) {
            this.reader = reader;
            this.parser = parser;
        }
    }
}

