/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model.destination;

import com.amazonaws.regions.Regions;
import io.skylite.core.common.Strings;
import io.skylite.core.notifications.model.destination.BaseDestination;
import io.skylite.core.notifications.model.destination.DestinationType;
import io.skylite.core.notifications.model.destination.ValidationHelpers;
import java.util.Arrays;

public class SesDestination
extends BaseDestination {
    private final String accountName;
    private final String awsRegion;
    private final String roleArn;
    private final String fromAddress;
    private final String recipient;

    public SesDestination(String accountName, String awsRegion, String roleArn, String fromAddress, String recipient) {
        super(DestinationType.SES);
        if (Strings.isNullOrEmpty(awsRegion)) {
            throw new IllegalArgumentException("aws region should be provided");
        }
        boolean isValidRegion = Arrays.stream(Regions.values()).anyMatch(region -> region.getName().equals(awsRegion));
        if (!isValidRegion) {
            throw new IllegalArgumentException("aws region is not valid");
        }
        ValidationHelpers.validateEmail(fromAddress);
        ValidationHelpers.validateEmail(recipient);
        this.accountName = accountName;
        this.awsRegion = awsRegion;
        this.roleArn = roleArn;
        this.fromAddress = fromAddress;
        this.recipient = recipient;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getRecipient() {
        return this.recipient;
    }
}

