/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model.destination;

import io.skylite.core.common.Strings;
import io.skylite.core.notifications.model.destination.BaseDestination;
import io.skylite.core.notifications.model.destination.DestinationType;
import io.skylite.core.notifications.model.destination.ValidationHelpers;

public class SmtpDestination
extends BaseDestination {
    private final String accountName;
    private final String host;
    private final int port;
    private final String method;
    private final String fromAddress;
    private final String recipient;

    public SmtpDestination(String accountName, String host, int port, String method, String fromAddress, String recipient) {
        super(DestinationType.SMTP);
        if (Strings.isNullOrEmpty(host)) {
            throw new IllegalArgumentException("Host name should be provided");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("Port should be positive value");
        }
        ValidationHelpers.validateEmail(fromAddress);
        ValidationHelpers.validateEmail(recipient);
        this.accountName = accountName;
        this.host = host;
        this.port = port;
        this.method = method;
        this.fromAddress = fromAddress;
        this.recipient = recipient;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getMethod() {
        return this.method;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getRecipient() {
        return this.recipient;
    }
}

