/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model.destination;

import io.skylite.core.notifications.model.destination.BaseDestination;
import io.skylite.core.notifications.model.destination.DestinationType;
import java.util.Objects;

public class SnsDestination
extends BaseDestination {
    private final String topicArn;
    private final String roleArn;
    private final String region;

    public SnsDestination(String topicArn) {
        this(topicArn, null);
    }

    public SnsDestination(String topicArn, String roleArn) {
        super(DestinationType.SNS);
        this.topicArn = topicArn;
        this.roleArn = roleArn;
        this.region = topicArn.split(":")[3];
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnsDestination that = (SnsDestination)o;
        return Objects.equals(this.topicArn, that.topicArn) && Objects.equals(this.roleArn, that.roleArn);
    }

    public int hashCode() {
        return Objects.hash(this.topicArn, this.roleArn);
    }

    public String toString() {
        return "SnsDestination{topicArn='" + this.topicArn + "', roleArn='" + this.roleArn + "', region='" + this.region + "'}";
    }
}

