/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.notifications.model.destination;

import inet.ipaddr.HostName;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import io.skylite.common.network.NetworkAddress;
import io.skylite.core.common.Strings;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ValidationHelpers {
    private static final Logger logger = LogManager.getLogger(ValidationHelpers.class);
    private static final String FQDN_REGEX = "^(?!.*?_.*?)(?!(?:\\w+?\\.)?-[\\w.\\-]*?)(?!\\w+?-\\.[\\w.\\-]+?)(?=\\w)(?=[\\w.\\-]*?\\.+[\\w.\\-]*?)(?![\\w.\\-]{254})(?!(?:\\.?[\\w\\-.]*?[\\w\\-]{64,}\\.)+?)[\\w.\\-]+?(?<![\\w\\-.]?\\.\\d?)(?<=[\\w\\-]{2,})(?<![\\w\\-]{25})$";
    private static final Pattern FQDN_PATTERN = Pattern.compile("^(?!.*?_.*?)(?!(?:\\w+?\\.)?-[\\w.\\-]*?)(?!\\w+?-\\.[\\w.\\-]+?)(?=\\w)(?=[\\w.\\-]*?\\.+[\\w.\\-]*?)(?![\\w.\\-]{254})(?!(?:\\.?[\\w\\-.]*?[\\w\\-]{64,}\\.)+?)[\\w.\\-]+?(?<![\\w\\-.]?\\.\\d?)(?<=[\\w\\-]{2,})(?<![\\w\\-]{25})$");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])", 2);
    private static final List<String> VALID_METHODS = Arrays.asList("POST", "PUT", "PATCH");

    private ValidationHelpers() {
    }

    public static void validateUrl(String urlString) {
        if (Strings.isNullOrEmpty(urlString)) {
            throw new IllegalArgumentException("url is null or empty");
        }
        if (!ValidationHelpers.isValidUrl(urlString)) {
            throw new IllegalArgumentException("Invalid URL or unsupported");
        }
    }

    public static void validateEmail(String email) {
        if (Strings.isNullOrEmpty(email)) {
            throw new IllegalArgumentException("FromAddress and recipient should be provided");
        }
        if (!ValidationHelpers.isValidEmail(email)) {
            throw new IllegalArgumentException("Invalid email address");
        }
    }

    public static boolean isValidUrl(String urlString) {
        try {
            URL url = new URL(urlString);
            int index = urlString.indexOf("//") + 2;
            String subString = urlString.substring(index);
            boolean isFQDN = FQDN_PATTERN.matcher(subString).matches();
            if (isFQDN && !DomainValidator.getInstance().isValid(subString)) {
                return false;
            }
            if (subString.equals(url.getHost())) {
                return ("https".equals(url.getProtocol()) || "http".equals(url.getProtocol())) && isFQDN;
            }
            return ("https".equals(url.getProtocol()) || "http".equals(url.getProtocol())) && !isFQDN;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<IPAddressString> getResolvedIps(String host) {
        try {
            InetAddress[] resolvedIps = InetAddress.getAllByName(host);
            return Arrays.stream(resolvedIps).map(inetAddress -> new IPAddressString(NetworkAddress.format((InetAddress)inetAddress))).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Unable to resolve host ips");
            return Collections.emptyList();
        }
    }

    public static boolean isHostInDenylist(String urlString, List<String> hostDenyList) {
        try {
            URL url = new URL(urlString);
            if (url.getHost() != null) {
                IPAddress hostAddr;
                IPAddressString hostIpAddress = new IPAddressString(url.getHost());
                HostName hostStr = new HostName(url.getHost());
                List<IPAddressString> denyNetworks = hostDenyList.stream().map(IPAddressString::new).collect(Collectors.toList());
                List denyHostnames = hostDenyList.stream().map(HostName::new).collect(Collectors.toList());
                for (HostName denyHostStr : denyHostnames) {
                    if (!denyHostStr.equals((Object)hostStr)) continue;
                    logger.error("{} is denied (hostname in denylist)", (Object)url.getHost());
                    return true;
                }
                if (hostIpAddress.isValid() && (hostAddr = hostIpAddress.getAddress()) != null && ValidationHelpers.isIpInDenylist(hostAddr, denyNetworks, url.getHost())) {
                    return true;
                }
                List<IPAddressString> resolvedIpStrings = ValidationHelpers.getResolvedIps(url.getHost());
                for (IPAddressString ipStr : resolvedIpStrings) {
                    IPAddress resolvedAddr = ipStr.getAddress();
                    if (resolvedAddr == null || !ValidationHelpers.isIpInDenylist(resolvedAddr, denyNetworks, url.getHost())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error checking host in denylist", (Throwable)e);
        }
        return false;
    }

    private static boolean isIpInDenylist(IPAddress ip, List<IPAddressString> denyNetworks, String host) {
        ArrayList<Object> candidates = new ArrayList<Object>();
        candidates.add(ip);
        if (ip.isIPv4()) {
            try {
                IPAddress ipv6Mapped = new IPAddressString("::ffff:" + ip.toNormalizedString()).getAddress();
                if (ipv6Mapped != null) {
                    candidates.add(ipv6Mapped);
                }
            }
            catch (Exception e) {
                logger.debug("Failed to create IPv6-mapped address for {}", (Object)ip);
            }
        }
        if (ip.isIPv6()) {
            try {
                IPv4Address iPv4Address;
                IPv4Address iPv4Address2;
                IPv6Address ipv6Address = ip.toIPv6();
                if (ipv6Address.isIPv4Mapped() && (iPv4Address2 = ipv6Address.getEmbeddedIPv4Address()) != null) {
                    candidates.add(iPv4Address2);
                }
                if (ipv6Address.isIPv4Compatible() && (iPv4Address = ipv6Address.getEmbeddedIPv4Address()) != null) {
                    candidates.add(iPv4Address);
                }
            }
            catch (Exception e) {
                logger.debug("Failed to extract IPv4 from IPv6 address {}", (Object)ip);
            }
        }
        for (IPAddress iPAddress : candidates) {
            for (IPAddressString denyNetwork : denyNetworks) {
                IPAddress denyAddr = denyNetwork.getAddress();
                if (denyAddr == null || (!iPAddress.isZero() || !denyAddr.isZero()) && !denyAddr.contains(iPAddress)) continue;
                logger.error("{} is denied by rule {} (matched {})", (Object)host, (Object)denyNetwork.toNormalizedString(), (Object)iPAddress.toNormalizedString());
                return true;
            }
        }
        return false;
    }

    public static boolean isValidEmail(String email) {
        return EMAIL_PATTERN.matcher(email).matches();
    }

    public static void validateMethod(String method) {
        if (Strings.isNullOrEmpty(method)) {
            throw new IllegalArgumentException("Method is null or empty");
        }
        boolean isValid = VALID_METHODS.stream().anyMatch(method::contains);
        if (!isValid) {
            throw new IllegalArgumentException("Invalid method supplied. Only POST, PUT and PATCH are allowed");
        }
    }
}

