/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.replication;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.replication.action.ReplicationActions;
import io.skylite.core.replication.action.StopIndexReplicationRequest;

public final class ReplicationPluginInterface {
    private ReplicationPluginInterface() {
    }

    public static void stopReplication(Client client, StopIndexReplicationRequest request, ActionListener<AcknowledgedResponse> listener) {
        NodeClient nodeClient = (NodeClient)client;
        nodeClient.execute(ReplicationActions.INTERNAL_STOP_REPLICATION_ACTION_TYPE, request, ReplicationPluginInterface.wrapActionListener(listener, in -> new AcknowledgedResponse(in)));
    }

    private static <Response extends AcknowledgedResponse> ActionListener<Response> wrapActionListener(final ActionListener<Response> listener, final Writeable.Reader<Response> reader) {
        return new ActionListener<ActionResponse>(){

            public void onResponse(ActionResponse response) {
                AcknowledgedResponse recreated;
                try {
                    recreated = (AcknowledgedResponse)response;
                }
                catch (ClassCastException e) {
                    recreated = (AcknowledgedResponse)Writeable.recreateObject(response, reader);
                }
                listener.onResponse((Object)recreated);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }
}

