/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.repositories.IndexId;
import java.io.IOException;
import java.util.Objects;

public final class RepositoryShardId
implements Writeable {
    private final IndexId index;
    private final int shard;

    public RepositoryShardId(IndexId index, int shard) {
        assert (index != null);
        this.index = index;
        this.shard = shard;
    }

    public RepositoryShardId(StreamInput in) throws IOException {
        this(new IndexId(in), in.readVInt());
    }

    public IndexId index() {
        return this.index;
    }

    public String indexName() {
        return this.index.getName();
    }

    public int shardId() {
        return this.shard;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.shard);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RepositoryShardId)) {
            return false;
        }
        RepositoryShardId that = (RepositoryShardId)obj;
        return that.index.equals(this.index) && that.shard == this.shard;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shard);
    }

    public String toString() {
        return "RepositoryShardId{" + String.valueOf(this.index) + "}{" + this.shard + "}";
    }
}

