/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories;

import io.skylite.common.Nullable;
import io.skylite.core.blobstore.BlobStore;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RepositoryStats
implements Writeable,
ToXContentFragment {
    public static final RepositoryStats EMPTY_STATS = new RepositoryStats(Collections.emptyMap());
    @Nullable
    public final Map<String, Long> requestCounts;
    @Nullable
    public final Map<BlobStore.Metric, Map<String, Long>> extendedStats;
    public final boolean detailed;

    public RepositoryStats(Map<String, Long> requestCounts) {
        this.requestCounts = Collections.unmodifiableMap(requestCounts);
        this.extendedStats = Collections.emptyMap();
        this.detailed = false;
    }

    public RepositoryStats(Map<BlobStore.Metric, Map<String, Long>> extendedStats, boolean detailed) {
        this.requestCounts = Collections.emptyMap();
        this.extendedStats = Collections.unmodifiableMap(extendedStats);
        this.detailed = detailed;
    }

    public RepositoryStats(StreamInput in) throws IOException {
        this.requestCounts = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.extendedStats = in.readMap(e -> e.readEnum(BlobStore.Metric.class), i -> i.readMap(StreamInput::readString, StreamInput::readLong));
        this.detailed = in.readBoolean();
    }

    public RepositoryStats merge(RepositoryStats otherStats) {
        assert (this.detailed == otherStats.detailed);
        if (this.detailed) {
            HashMap<BlobStore.Metric, Map<String, Long>> result = new HashMap<BlobStore.Metric, Map<String, Long>>();
            result.putAll(this.extendedStats);
            for (Map.Entry<BlobStore.Metric, Map<String, Long>> entry : otherStats.extendedStats.entrySet()) {
                for (Map.Entry<String, Long> nested : entry.getValue().entrySet()) {
                    ((Map)result.get((Object)entry.getKey())).merge(nested.getKey(), nested.getValue(), Math::addExact);
                }
            }
            return new RepositoryStats(result, true);
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.putAll(this.requestCounts);
        for (Map.Entry<String, Long> entry : otherStats.requestCounts.entrySet()) {
            result.merge(entry.getKey(), entry.getValue(), Math::addExact);
        }
        return new RepositoryStats(result);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.requestCounts, StreamOutput::writeString, StreamOutput::writeLong);
        out.writeMap(this.extendedStats, StreamOutput::writeEnum, (o, v) -> o.writeMap(v, StreamOutput::writeString, StreamOutput::writeLong));
        out.writeBoolean(this.detailed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStats that = (RepositoryStats)o;
        return this.requestCounts.equals(that.requestCounts) && this.extendedStats.equals(that.extendedStats) && this.detailed == that.detailed;
    }

    public int hashCode() {
        return Objects.hash(this.requestCounts, this.detailed, this.extendedStats);
    }

    public String toString() {
        return "RepositoryStats{requestCounts=" + String.valueOf(this.requestCounts) + "extendedStats=" + String.valueOf(this.extendedStats) + "detailed =" + this.detailed + "}";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.detailed) {
            builder.field("request_counts", (Object)this.requestCounts);
        } else {
            this.extendedStats.forEach((k, v) -> {
                try {
                    builder.field(k.metricName(), v);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return builder;
    }
}

