/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories.blobstore;

import io.skylite.common.CheckedFunction;
import io.skylite.common.action.ActionListener;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.core.CorruptStateException;
import io.skylite.core.blobstore.AsyncMultiStreamBlobContainer;
import io.skylite.core.blobstore.stream.write.WritePriority;
import io.skylite.core.blobstore.transfer.RemoteTransferContainer;
import io.skylite.core.blobstore.transfer.stream.OffsetRangeIndexInputStream;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.Streams;
import io.skylite.core.compress.Compressor;
import io.skylite.core.index.store.ChecksumCombinationException;
import io.skylite.core.lucene.store.ByteArrayIndexInput;
import io.skylite.core.repositories.blobstore.BaseBlobStoreFormat;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.MetadataStateFormat;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;

public final class ChecksumBlobStoreFormat<T extends ToXContent>
extends BaseBlobStoreFormat<T> {
    public static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS;
    public static final int VERSION = 1;
    private final String codec;
    private final CheckedFunction<XContentParser, T, IOException> reader;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader) {
        super(blobNameFormat, false);
        this.reader = reader;
        this.codec = codec;
    }

    public T read(BlobContainer blobContainer, String name, NamedXContentRegistry namedXContentRegistry) throws IOException {
        String blobName = this.blobName(name);
        return this.deserialize(blobName, namedXContentRegistry, Streams.readFully(blobContainer.readBlob(blobName)));
    }

    @Override
    public String blobName(String name) {
        return String.format(Locale.ROOT, this.getBlobNameFormat(), name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String blobName, NamedXContentRegistry namedXContentRegistry, BytesReference bytes) throws IOException {
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try {
            Object indexInput = bytes.length() > 0 ? new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(BytesReference.toByteBuffers(bytes))), resourceDesc) : new ByteArrayIndexInput(resourceDesc, BytesRef.EMPTY_BYTES);
            CodecUtil.checksumEntireFile((IndexInput)indexInput);
            CodecUtil.checkHeader((DataInput)indexInput, (String)this.codec, (int)1, (int)1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            try (XContentParser parser = XContentHelper.createParser(namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, bytes.slice((int)filePointer, (int)contentSize), MetadataStateFormat.X_CONTENT_FORMAT);){
                ToXContent toXContent = (ToXContent)this.reader.apply((Object)parser);
                return (T)toXContent;
            }
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }

    public void write(T obj, BlobContainer blobContainer, String name, Compressor compressor) throws IOException {
        this.write(obj, blobContainer, name, compressor, SNAPSHOT_ONLY_FORMAT_PARAMS, MediaTypeRegistry.fromFormat("smile"), this.codec, 1);
    }

    public void writeAsync(T obj, BlobContainer blobContainer, String name, Compressor compressor, ActionListener<Void> listener, ToXContent.Params params) throws IOException {
        this.writeAsyncWithPriority(obj, blobContainer, name, compressor, WritePriority.NORMAL, listener, params);
    }

    public void writeAsyncWithUrgentPriority(T obj, BlobContainer blobContainer, String name, Compressor compressor, ActionListener<Void> listener, ToXContent.Params params) throws IOException {
        this.writeAsyncWithPriority(obj, blobContainer, name, compressor, WritePriority.URGENT, listener, params);
    }

    private void writeAsyncWithPriority(T obj, BlobContainer blobContainer, String name, Compressor compressor, WritePriority priority, ActionListener<Void> listener, ToXContent.Params params) throws IOException {
        if (!(blobContainer instanceof AsyncMultiStreamBlobContainer)) {
            this.write(obj, blobContainer, name, compressor, params, MediaTypeRegistry.fromFormat("smile"), this.codec, 1);
            listener.onResponse(null);
            return;
        }
        String blobName = this.blobName(name);
        BytesReference bytes = this.serialize(obj, blobName, compressor, params);
        String resourceDescription = "ChecksumBlobStoreFormat.writeAsyncWithPriority(blob=\"" + blobName + "\")";
        try (ByteArrayIndexInput input = new ByteArrayIndexInput(resourceDescription, BytesReference.toBytes(bytes));){
            long expectedChecksum;
            try {
                expectedChecksum = RemoteTransferContainer.checksumOfChecksum(input.clone(), 8);
            }
            catch (Exception e) {
                throw new ChecksumCombinationException("Potentially corrupted file: Checksum combination failed while combining stored checksum and calculated checksum of stored checksum", resourceDescription, e);
            }
            try (RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(blobName, blobName, bytes.length(), true, priority, (size, position) -> new OffsetRangeIndexInputStream(input, size, position), expectedChecksum, ((AsyncMultiStreamBlobContainer)blobContainer).remoteIntegrityCheckSupported());){
                ((AsyncMultiStreamBlobContainer)blobContainer).asyncBlobUpload(remoteTransferContainer.createWriteContext(), listener);
            }
        }
    }

    public BytesReference serialize(T obj, String blobName, Compressor compressor, ToXContent.Params params) throws IOException {
        return this.serialize(obj, blobName, compressor, params, MediaTypeRegistry.fromFormat("smile"), this.codec, 1);
    }

    static {
        HashMap<String, String> snapshotOnlyParams = new HashMap<String, String>();
        snapshotOnlyParams.put("context_mode", Metadata.CONTEXT_MODE_SNAPSHOT);
        snapshotOnlyParams.put("context_mode", "SNAPSHOT");
        SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(snapshotOnlyParams);
    }
}

