/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.repositories.blobstore;

import io.skylite.common.action.ActionListener;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.core.blobstore.AsyncMultiStreamBlobContainer;
import io.skylite.core.blobstore.stream.write.WritePriority;
import io.skylite.core.blobstore.transfer.RemoteTransferContainer;
import io.skylite.core.blobstore.transfer.stream.OffsetRangeIndexInputStream;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.compress.NoneCompressor;
import io.skylite.core.lucene.store.ByteArrayIndexInput;
import io.skylite.core.repositories.blobstore.BaseBlobStoreFormat;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;

public class ConfigBlobStoreFormat<T extends ToXContent>
extends BaseBlobStoreFormat<T> {
    public ConfigBlobStoreFormat(String blobNameFormat) {
        super(blobNameFormat, true);
    }

    public void writeAsyncWithUrgentPriority(T obj, BlobContainer blobContainer, String name, ActionListener<Void> listener) throws IOException {
        if (!(blobContainer instanceof AsyncMultiStreamBlobContainer)) {
            this.write(obj, blobContainer, name, new NoneCompressor(), ToXContent.EMPTY_PARAMS, MediaTypeRegistry.JSON, null, null);
            listener.onResponse(null);
            return;
        }
        String blobName = this.blobName(name);
        BytesReference bytes = this.serialize(obj, blobName, new NoneCompressor(), ToXContent.EMPTY_PARAMS, MediaTypeRegistry.JSON, null, null);
        String resourceDescription = "BlobStoreFormat.writeAsyncWithPriority(blob=\"" + blobName + "\")";
        try (ByteArrayIndexInput input = new ByteArrayIndexInput(resourceDescription, BytesReference.toBytes(bytes));
             RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(blobName, blobName, bytes.length(), true, WritePriority.URGENT, (size, position) -> new OffsetRangeIndexInputStream(input, size, position), null, false);){
            ((AsyncMultiStreamBlobContainer)blobContainer).asyncBlobUpload(remoteTransferContainer.createWriteContext(), listener);
        }
    }
}

