/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.rest;

import io.skylite.common.Nullable;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.Streams;
import io.skylite.core.common.io.stream.BytesStream;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractRestChannel
implements RestChannel {
    private static final Predicate<String> INCLUDE_FILTER = f -> f.charAt(0) != '-';
    private static final Predicate<String> EXCLUDE_FILTER = INCLUDE_FILTER.negate();
    protected final RestRequest request;
    private final boolean detailedErrorsEnabled;
    private final String format;
    private final String filterPath;
    private final boolean pretty;
    private final boolean human;
    private final String acceptHeader;
    private BytesStreamOutput bytesOut;

    protected AbstractRestChannel(RestRequest request, boolean detailedErrorsEnabled) {
        this.request = request;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.format = request.param("format");
        this.acceptHeader = request.header("Accept");
        this.filterPath = request.param("filter_path", null);
        this.pretty = request.paramAsBoolean("pretty", false);
        this.human = request.paramAsBoolean("human", false);
    }

    @Override
    public XContentBuilder newBuilder() throws IOException {
        return this.newBuilder(this.request.getMediaType(), true);
    }

    @Override
    public XContentBuilder newErrorBuilder() throws IOException {
        return this.newBuilder(this.request.getMediaType(), false);
    }

    @Override
    public XContentBuilder newBuilder(@Nullable MediaType requestContentType, boolean useFiltering) throws IOException {
        return this.newBuilder(requestContentType, null, useFiltering);
    }

    @Override
    public XContentBuilder newBuilder(@Nullable MediaType requestContentType, @Nullable MediaType responseContentType, boolean useFiltering) throws IOException {
        if (responseContentType == null && (responseContentType = MediaType.fromFormat(this.format)) == null) {
            responseContentType = MediaType.fromMediaType(this.acceptHeader);
        }
        if (responseContentType == null) {
            responseContentType = requestContentType != null ? requestContentType : MediaTypeRegistry.getDefaultMediaType();
        }
        Set<String> includes = Collections.emptySet();
        Set<String> excludes = Collections.emptySet();
        if (useFiltering) {
            Set<String> filters = Strings.tokenizeByCommaToSet(this.filterPath);
            includes = filters.stream().filter(INCLUDE_FILTER).collect(Collectors.toSet());
            excludes = filters.stream().filter(EXCLUDE_FILTER).map(f -> f.substring(1)).collect(Collectors.toSet());
        }
        BytesStream unclosableOutputStream = Streams.flushOnCloseStream(this.bytesOutput());
        XContentBuilder builder = new XContentBuilder(responseContentType.xContent(), unclosableOutputStream, includes, excludes);
        if (this.pretty) {
            builder.prettyPrint().lfAtEnd();
        }
        builder.humanReadable(this.human);
        return builder;
    }

    @Override
    public final BytesStreamOutput bytesOutput() {
        if (this.bytesOut == null) {
            this.bytesOut = this.newBytesOutput();
        } else {
            this.bytesOut.reset();
        }
        return this.bytesOut;
    }

    protected final BytesStreamOutput bytesOutputOrNull() {
        return this.bytesOut;
    }

    protected BytesStreamOutput newBytesOutput() {
        return new BytesStreamOutput();
    }

    @Override
    public RestRequest request() {
        return this.request;
    }

    @Override
    public boolean detailedErrorsEnabled() {
        return this.detailedErrorsEnabled;
    }
}

