/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.script;

import io.skylite.common.MutatingMap;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptFactory;
import io.skylite.core.search.lookup.LeafSearchLookup;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;

public abstract class FieldScript {
    public static final String[] PARAMETERS = new String[0];
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MutatingMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
        deprecationLogger.deprecate("field-script_doc", "Accessing variable [doc] via [params.doc] from within an field-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.deprecate("field-script__doc", "Accessing variable [doc] via [params._doc] from within an field-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("field", Factory.class);

    public FieldScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        params = new HashMap<String, Object>(params);
        params.putAll(this.leafLookup.asMap());
        this.params = new MutatingMap(params, PARAMS_FUNCTIONS);
    }

    protected FieldScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public abstract Object execute();

    protected final LeafSearchLookup getLeafLookup() {
        return this.leafLookup;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public final Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public FieldScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

