/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.script;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ScriptException
extends SkyliteException {
    private final List<String> scriptStack;
    private final String script;
    private final String lang;
    private final Position pos;

    public ScriptException(String message, Throwable cause, List<String> scriptStack, String script, String lang, Position pos) {
        super(Objects.requireNonNull(message), Objects.requireNonNull(cause), new Object[0]);
        this.scriptStack = Collections.unmodifiableList(Objects.requireNonNull(scriptStack));
        this.script = Objects.requireNonNull(script);
        this.lang = Objects.requireNonNull(lang);
        this.pos = pos;
    }

    public ScriptException(String message, Throwable cause, List<String> scriptStack, String script, String lang) {
        this(message, cause, scriptStack, script, lang, null);
    }

    public ScriptException(StreamInput in) throws IOException {
        super(in);
        this.scriptStack = Arrays.asList(in.readStringArray());
        this.script = in.readString();
        this.lang = in.readString();
        this.pos = Position.readFromOptional(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.scriptStack.toArray(new String[0]));
        out.writeString(this.script);
        out.writeString(this.lang);
        Position.writeToOptional(out, this.pos);
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("script_stack", this.scriptStack);
        builder.field("script", this.script);
        builder.field("lang", this.lang);
        if (this.pos != null) {
            this.pos.toXContent(builder, params);
        }
    }

    public List<String> getScriptStack() {
        return this.scriptStack;
    }

    public String getScript() {
        return this.script;
    }

    public String getLang() {
        return this.lang;
    }

    public Position getPos() {
        return this.pos;
    }

    public String toJsonString() {
        try {
            XContentBuilder json = MediaTypeRegistry.JSON.contentBuilder().prettyPrint();
            json.startObject();
            this.toXContent(json, ToXContent.EMPTY_PARAMS);
            json.endObject();
            return json.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public static class Position {
        public final int offset;
        public final int start;
        public final int end;

        public Position(int offset, int start, int end) {
            this.offset = offset;
            this.start = start;
            this.end = end;
        }

        Position(StreamInput in) throws IOException {
            this.offset = in.readInt();
            this.start = in.readInt();
            this.end = in.readInt();
        }

        public static Position readFromOptional(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                return new Position(in);
            }
            return null;
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.offset);
            out.writeInt(this.start);
            out.writeInt(this.end);
        }

        public static void writeToOptional(StreamOutput out, Position object) throws IOException {
            boolean present = object != null;
            out.writeBoolean(present);
            if (present) {
                object.writeTo(out);
            }
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("position");
            builder.field("offset", this.offset);
            builder.field("start", this.start);
            builder.field("end", this.end);
            builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            return this.offset == position.offset && this.start == position.start && this.end == position.end;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.start, this.end);
        }
    }

    public static class Registration
    implements SkyliteExceptionProvider<ScriptException> {
        @Override
        public Class<ScriptException> getExceptionClass() {
            return ScriptException.class;
        }

        @Override
        public CheckedFunction<StreamInput, ScriptException, IOException> getConstructor() {
            return ScriptException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 143;
        }
    }
}

