/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.script;

import io.skylite.common.metrics.CounterMetric;
import io.skylite.core.script.ScriptContextStats;
import io.skylite.core.script.ScriptStats;

public class ScriptMetrics {
    final CounterMetric compilationsMetric = new CounterMetric();
    final CounterMetric cacheEvictionsMetric = new CounterMetric();
    final CounterMetric compilationLimitTriggered = new CounterMetric();

    public void onCompilation() {
        this.compilationsMetric.inc();
    }

    public void onCacheEviction() {
        this.cacheEvictionsMetric.inc();
    }

    public void onCompilationLimit() {
        this.compilationLimitTriggered.inc();
    }

    public ScriptStats stats() {
        return new ScriptStats(this.compilationsMetric.count(), this.cacheEvictionsMetric.count(), this.compilationLimitTriggered.count());
    }

    public ScriptContextStats stats(String context) {
        return new ScriptContextStats(context, this.compilationsMetric.count(), this.cacheEvictionsMetric.count(), this.compilationLimitTriggered.count());
    }
}

