/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.script;

import io.skylite.common.annotation.PublicApi;
import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Locale;

@PublicApi(since="1.0.0")
public enum ScriptType implements Writeable
{
    INLINE(0, new ParseField("source", "inline")),
    STORED(1, new ParseField("id", "stored"));

    private final int id;
    private final ParseField parseField;

    public static ScriptType readFrom(StreamInput in) throws IOException {
        int id = in.readVInt();
        if (ScriptType.STORED.id == id) {
            return STORED;
        }
        if (ScriptType.INLINE.id == id) {
            return INLINE;
        }
        throw new IllegalStateException("Error reading ScriptType id [" + id + "] from stream, expected one of [" + ScriptType.STORED.id + " [" + ScriptType.STORED.parseField.getPreferredName() + "], " + ScriptType.INLINE.id + " [" + ScriptType.INLINE.parseField.getPreferredName() + "]]");
    }

    private ScriptType(int id, ParseField parseField) {
        this.id = id;
        this.parseField = parseField;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ParseField getParseField() {
        return this.parseField;
    }

    public String toString() {
        return this.getName();
    }
}

