/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.script;

import io.skylite.common.MutatingMap;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptFactory;
import io.skylite.core.search.lookup.LeafSearchLookup;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;

public abstract class TermsSetQueryScript {
    public static final String[] PARAMETERS = new String[0];
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("terms_set", Factory.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MutatingMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
        deprecationLogger.deprecate("terms-set-query-script_doc", "Accessing variable [doc] via [params.doc] from within an terms-set-query-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.deprecate("terms-set-query-script__doc", "Accessing variable [doc] via [params._doc] from within an terms-set-query-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;

    public TermsSetQueryScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        parameters.putAll(this.leafLookup.asMap());
        this.params = new MutatingMap(parameters, PARAMS_FUNCTIONS);
    }

    protected TermsSetQueryScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public long runAsLong() {
        return this.execute().longValue();
    }

    public abstract Number execute();

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public TermsSetQueryScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

