/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search;

import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.concurrent.ConcurrentMapLong;
import io.skylite.core.action.search.DeletePitResponse;
import io.skylite.core.action.search.PitSearchContextIdForNode;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.action.search.UpdatePitContextRequest;
import io.skylite.core.action.search.UpdatePitContextResponse;
import io.skylite.core.action.search.query.QuerySearchRequest;
import io.skylite.core.action.search.query.ScrollQuerySearchResult;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.node.ResponseCollectorService;
import io.skylite.core.search.SearchContextMissingException;
import io.skylite.core.search.SearchPhaseResult;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.dfs.DfsSearchResult;
import io.skylite.core.search.fetch.FetchSearchResult;
import io.skylite.core.search.fetch.ScrollQueryFetchSearchResult;
import io.skylite.core.search.fetch.ShardFetchRequest;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.search.internal.InternalScrollSearchRequest;
import io.skylite.core.search.internal.ReaderContext;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.query.QuerySearchResult;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseSearchService
extends AbstractLifecycleComponent {
    public static final int DEFAULT_SIZE = 10;
    public static final int DEFAULT_FROM = 0;
    private static final Logger logger = LogManager.getLogger(BaseSearchService.class);
    protected final ConcurrentMapLong<ReaderContext> activeReaders = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    protected final String sessionId = UUIDs.randomBase64UUID();
    protected final ResponseCollectorService responseCollectorService;
    protected volatile boolean defaultAllowPartialSearchResults;

    public BaseSearchService(ResponseCollectorService responseCollectorService) {
        this.responseCollectorService = responseCollectorService;
    }

    protected ReaderContext removeReaderContext(long id) {
        return (ReaderContext)this.activeReaders.remove(id);
    }

    protected ReaderContext getReaderContext(ShardSearchContextId id) {
        if (!this.sessionId.equals(id.getSessionId()) && !id.getSessionId().isEmpty()) {
            throw new SearchContextMissingException(id);
        }
        return (ReaderContext)this.activeReaders.get(id.getId());
    }

    public boolean freeReaderContext(ShardSearchContextId contextId) {
        if (this.getReaderContext(contextId) != null) {
            try (ReaderContext context = this.removeReaderContext(contextId.getId());){
                boolean bl = context != null;
                return bl;
            }
        }
        return false;
    }

    public void freeAllScrollContexts() {
        for (ReaderContext readerContext : this.activeReaders.values()) {
            if (readerContext.scrollContext() == null) continue;
            this.freeReaderContext(readerContext.id());
        }
    }

    public ResponseCollectorService getResponseCollectorService() {
        return this.responseCollectorService;
    }

    public abstract AliasFilter buildAliasFilter(ClusterState var1, String var2, Set<String> var3);

    public abstract DeletePitResponse freeReaderContextsIfFound(List<PitSearchContextIdForNode> var1);

    protected abstract DfsSearchResult executeDfsPhase(ShardSearchRequest var1, SearchShardTask var2, boolean var3) throws IOException;

    protected void setDefaultAllowPartialSearchResults(boolean defaultAllowPartialSearchResults) {
        this.defaultAllowPartialSearchResults = defaultAllowPartialSearchResults;
    }

    public boolean defaultAllowPartialSearchResults() {
        return this.defaultAllowPartialSearchResults;
    }

    public abstract void executeDfsPhase(ShardSearchRequest var1, boolean var2, SearchShardTask var3, ActionListener<SearchPhaseResult> var4);

    public abstract void executeQueryPhase(ShardSearchRequest var1, boolean var2, SearchShardTask var3, ActionListener<SearchPhaseResult> var4);

    public abstract void executeQueryPhase(QuerySearchRequest var1, SearchShardTask var2, ActionListener<QuerySearchResult> var3);

    protected abstract SearchPhaseResult executeQueryPhase(ShardSearchRequest var1, SearchShardTask var2, boolean var3) throws Exception;

    public abstract void executeQueryPhase(InternalScrollSearchRequest var1, SearchShardTask var2, ActionListener<ScrollQuerySearchResult> var3);

    public abstract void executeFetchPhase(InternalScrollSearchRequest var1, SearchShardTask var2, ActionListener<ScrollQueryFetchSearchResult> var3);

    public abstract void executeFetchPhase(ShardFetchRequest var1, SearchShardTask var2, ActionListener<FetchSearchResult> var3);

    public abstract SearchPhaseResult.CanMatchResponse canMatch(ShardSearchRequest var1) throws IOException;

    public static boolean canRewriteToMatchNone(SearchSourceBuilder source) {
        if (source == null || source.query() == null || source.query() instanceof MatchAllQueryBuilder || source.suggest() != null) {
            return false;
        }
        AggregatorFactories.Builder aggregations = source.aggregations();
        return aggregations == null || !aggregations.mustVisitAllDocs();
    }

    public abstract QueryRewriteContext getRewriteContext(LongSupplier var1);

    public abstract InternalAggregation.ReduceContextBuilder aggReduceContextBuilder(SearchSourceBuilder var1);

    public abstract void canMatch(ShardSearchRequest var1, ActionListener<SearchPhaseResult.CanMatchResponse> var2);

    public abstract void createPitReaderContext(ShardId var1, TimeValue var2, ActionListener<ShardSearchContextId> var3);

    public abstract void updatePitIdAndKeepAlive(UpdatePitContextRequest var1, ActionListener<UpdatePitContextResponse> var2);
}

