/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search;

import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.RescoreDocIds;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.fetch.FetchSearchResult;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.sort.MinAndMax;
import io.skylite.core.transport.TransportResponse;
import java.io.IOException;

public abstract class SearchPhaseResult
extends TransportResponse {
    private SearchShardTarget searchShardTarget;
    private int shardIndex = -1;
    protected ShardSearchContextId contextId;
    private ShardSearchRequest shardSearchRequest;
    private RescoreDocIds rescoreDocIds = RescoreDocIds.EMPTY;

    protected SearchPhaseResult() {
    }

    protected SearchPhaseResult(StreamInput in) throws IOException {
        super(in);
    }

    @Nullable
    public ShardSearchContextId getContextId() {
        return this.contextId;
    }

    public int getShardIndex() {
        assert (this.shardIndex != -1) : "shardIndex is not set";
        return this.shardIndex;
    }

    public SearchShardTarget getSearchShardTarget() {
        return this.searchShardTarget;
    }

    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        this.searchShardTarget = shardTarget;
    }

    public void setShardIndex(int shardIndex) {
        assert (shardIndex >= 0) : "shardIndex must be >= 0 but was: " + shardIndex;
        this.shardIndex = shardIndex;
    }

    public QuerySearchResult queryResult() {
        return null;
    }

    public FetchSearchResult fetchResult() {
        return null;
    }

    @Nullable
    public ShardSearchRequest getShardSearchRequest() {
        return this.shardSearchRequest;
    }

    public void setShardSearchRequest(ShardSearchRequest shardSearchRequest) {
        this.shardSearchRequest = shardSearchRequest;
    }

    public RescoreDocIds getRescoreDocIds() {
        return this.rescoreDocIds;
    }

    public void setRescoreDocIds(RescoreDocIds rescoreDocIds) {
        this.rescoreDocIds = rescoreDocIds;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    public static final class CanMatchResponse
    extends SearchPhaseResult {
        private final boolean canMatch;
        private final MinAndMax<?> estimatedMinAndMax;

        public CanMatchResponse(StreamInput in) throws IOException {
            super(in);
            this.canMatch = in.readBoolean();
            this.estimatedMinAndMax = in.readOptionalWriteable(MinAndMax::new);
        }

        public CanMatchResponse(boolean canMatch, MinAndMax<?> estimatedMinAndMax) {
            this.canMatch = canMatch;
            this.estimatedMinAndMax = estimatedMinAndMax;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.canMatch);
            out.writeOptionalWriteable(this.estimatedMinAndMax);
        }

        public boolean canMatch() {
            return this.canMatch;
        }

        public MinAndMax<?> estimatedMinAndMax() {
            return this.estimatedMinAndMax;
        }
    }
}

