/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.collapse;

import io.skylite.core.index.query.InnerHitBuilder;
import io.skylite.core.lucene.search.grouping.SinglePassGroupingCollector;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.KeywordFieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.NumberFieldMapper;
import java.util.List;
import org.apache.lucene.search.Sort;

public class CollapseContext {
    private final String fieldName;
    private final MappedFieldType fieldType;
    private final List<InnerHitBuilder> innerHits;

    public CollapseContext(String fieldName, MappedFieldType fieldType, List<InnerHitBuilder> innerHits) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.innerHits = innerHits;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public BaseMappedFieldType getFieldType() {
        return this.fieldType;
    }

    public List<InnerHitBuilder> getInnerHit() {
        return this.innerHits;
    }

    public SinglePassGroupingCollector<?> createTopDocs(Sort sort, int topN) {
        if (this.fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
            return SinglePassGroupingCollector.createKeyword(this.fieldName, this.fieldType, sort, topN, null);
        }
        if (this.fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return SinglePassGroupingCollector.createNumeric(this.fieldName, this.fieldType, sort, topN, null);
        }
        throw new IllegalStateException("unknown type for collapse field " + this.fieldName + ", only keywords and numbers are accepted");
    }
}

