/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.fetch;

import io.skylite.common.Nullable;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.search.RescoreDocIds;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;

public class ShardFetchRequest
extends TransportRequest {
    private ShardSearchContextId contextId;
    private int[] docIds;
    private int size;
    private ScoreDoc lastEmittedDoc;

    public ShardFetchRequest(ShardSearchContextId contextId, Collection<Integer> list, ScoreDoc lastEmittedDoc) {
        this.contextId = contextId;
        this.docIds = list.stream().mapToInt(Integer::intValue).toArray();
        this.size = list.size();
        this.lastEmittedDoc = lastEmittedDoc;
    }

    public ShardFetchRequest(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.size = in.readVInt();
        this.docIds = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.docIds[i] = in.readVInt();
        }
        byte flag = in.readByte();
        if (flag == 1) {
            this.lastEmittedDoc = Lucene.readFieldDoc(in);
        } else if (flag == 2) {
            this.lastEmittedDoc = Lucene.readScoreDoc(in);
        } else if (flag != 0) {
            throw new IOException("Unknown flag: " + flag);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
        out.writeVInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeVInt(this.docIds[i]);
        }
        if (this.lastEmittedDoc == null) {
            out.writeByte((byte)0);
        } else if (this.lastEmittedDoc instanceof FieldDoc) {
            out.writeByte((byte)1);
            Lucene.writeFieldDoc(out, (FieldDoc)this.lastEmittedDoc);
        } else {
            out.writeByte((byte)2);
            Lucene.writeScoreDoc(out, this.lastEmittedDoc);
        }
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    public int[] docIds() {
        return this.docIds;
    }

    public int docIdsSize() {
        return this.size;
    }

    public ScoreDoc lastEmittedDoc() {
        return this.lastEmittedDoc;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "id[" + String.valueOf(this.contextId) + "], size[" + this.size + "], lastEmittedDoc[" + String.valueOf(this.lastEmittedDoc) + "]";
    }

    @Nullable
    public ShardSearchRequest getShardSearchRequest() {
        return null;
    }

    @Nullable
    public RescoreDocIds getRescoreDocIds() {
        return null;
    }

    @Nullable
    public AggregatedDfs getAggregatedDfs() {
        return null;
    }
}

