/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.fetch;

import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.RescoreDocIds;
import io.skylite.core.search.dfs.AggregatedDfs;
import io.skylite.core.search.fetch.ShardFetchRequest;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.ScoreDoc;

public class ShardFetchSearchRequest
extends ShardFetchRequest
implements IndicesRequest {
    private final OriginalIndices originalIndices;
    private final ShardSearchRequest shardSearchRequest;
    private final RescoreDocIds rescoreDocIds;
    private final AggregatedDfs aggregatedDfs;

    public ShardFetchSearchRequest(OriginalIndices originalIndices, ShardSearchContextId id, ShardSearchRequest shardSearchRequest, List<Integer> list, ScoreDoc lastEmittedDoc, RescoreDocIds rescoreDocIds, AggregatedDfs aggregatedDfs) {
        super(id, list, lastEmittedDoc);
        this.originalIndices = originalIndices;
        this.shardSearchRequest = shardSearchRequest;
        this.rescoreDocIds = rescoreDocIds;
        this.aggregatedDfs = aggregatedDfs;
    }

    public ShardFetchSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.shardSearchRequest = in.readOptionalWriteable(ShardSearchRequest::new);
        this.rescoreDocIds = new RescoreDocIds(in);
        this.aggregatedDfs = in.readOptionalWriteable(AggregatedDfs::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalWriteable(this.shardSearchRequest);
        this.rescoreDocIds.writeTo(out);
        out.writeOptionalWriteable(this.aggregatedDfs);
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    @Override
    public ShardSearchRequest getShardSearchRequest() {
        return this.shardSearchRequest;
    }

    @Override
    public RescoreDocIds getRescoreDocIds() {
        return this.rescoreDocIds;
    }

    @Override
    public AggregatedDfs getAggregatedDfs() {
        return this.aggregatedDfs;
    }
}

