/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.Bits;

final class CancellableBulkScorer
extends BulkScorer {
    private static final int INITIAL_INTERVAL = 2048;
    private static final int MAX_INTERVAL = 0x100000;
    private final BulkScorer scorer;
    private final Runnable checkCancelled;

    CancellableBulkScorer(BulkScorer scorer, Runnable checkCancelled) {
        this.scorer = Objects.requireNonNull(scorer);
        this.checkCancelled = Objects.requireNonNull(checkCancelled);
    }

    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int interval = 2048;
        while (min < max) {
            this.checkCancelled.run();
            int newMax = (int)Math.min((long)min + (long)interval, (long)max);
            min = this.scorer.score(collector, acceptDocs, min, newMax);
            interval = Math.min(interval << 1, 0x100000);
        }
        this.checkCancelled.run();
        return min;
    }

    public long cost() {
        return this.scorer.cost();
    }
}

