/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.internal;

import io.skylite.OpenSearchVersion;
import io.skylite.core.action.search.SearchResponseSections;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.search.SearchHits;
import io.skylite.core.search.profile.SearchProfileShardResults;
import io.skylite.core.search.suggest.Suggest;
import io.skylite.core.xcontent.ToXContentFragment;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class InternalSearchResponse
extends SearchResponseSections
implements Writeable,
ToXContentFragment {
    public static InternalSearchResponse empty() {
        return InternalSearchResponse.empty(true);
    }

    public static InternalSearchResponse empty(boolean withTotalHits) {
        return new InternalSearchResponse(SearchHits.empty(withTotalHits), null, null, null, false, null, 1);
    }

    public InternalSearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, SearchProfileShardResults profileResults, boolean timedOut, Boolean terminatedEarly, int numReducePhases) {
        this(hits, aggregations, suggest, profileResults, timedOut, terminatedEarly, numReducePhases, Collections.emptyList());
    }

    public InternalSearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, SearchProfileShardResults profileResults, boolean timedOut, Boolean terminatedEarly, int numReducePhases, List<SearchExtBuilder> searchExtBuilderList) {
        super(hits, aggregations, suggest, timedOut, terminatedEarly, profileResults, numReducePhases, searchExtBuilderList);
    }

    public InternalSearchResponse(StreamInput in) throws IOException {
        super(new SearchHits(in), in.readBoolean() ? InternalAggregations.readFrom(in) : null, in.readBoolean() ? new Suggest(in) : null, in.readBoolean(), in.readOptionalBoolean(), in.readOptionalWriteable(SearchProfileShardResults::new), in.readVInt(), InternalSearchResponse.readSearchExtBuildersOnOrAfter(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.hits.writeTo(out);
        out.writeOptionalWriteable((InternalAggregations)this.aggregations);
        out.writeOptionalWriteable(this.suggest);
        out.writeBoolean(this.timedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileResults);
        out.writeVInt(this.numReducePhases);
        InternalSearchResponse.writeSearchExtBuildersOnOrAfter(out, this.searchExtBuilders);
    }

    private static List<SearchExtBuilder> readSearchExtBuildersOnOrAfter(StreamInput in) throws IOException {
        return in.getVersion().onOrAfter(OpenSearchVersion.V_2_10_0) ? in.readNamedWriteableList(SearchExtBuilder.class) : Collections.emptyList();
    }

    private static void writeSearchExtBuildersOnOrAfter(StreamOutput out, List<SearchExtBuilder> searchExtBuilders) throws IOException {
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_10_0)) {
            out.writeNamedWriteableList(searchExtBuilders);
        }
    }
}

